/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.structural.synchronization.utils;

import gnu.trove.map.hash.THashMap;
import gnu.trove.procedure.TObjectObjectProcedure;
import gnu.trove.procedure.TObjectProcedure;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicReference;
import org.simantics.databoard.annotations.Optional;

public abstract class ComponentBase<T extends ComponentBase<T>> {
    public int componentId;
    public String uid;
    protected transient T parent;
    @Optional
    public String solverComponentName;
    public boolean attached;

    public ComponentBase() {
    }

    public ComponentBase(String uid) {
        this.uid = uid;
    }

    public ComponentBase(String uid, int moduleId) {
        this.uid = uid;
        this.componentId = moduleId;
    }

    public ComponentBase(int moduleId) {
        this.componentId = moduleId;
    }

    public void detachByUid(final String uid) {
        final AtomicReference nameRef = new AtomicReference();
        this.getChildMap().forEachEntry(new TObjectObjectProcedure<String, T>(){

            public boolean execute(String name, T conf) {
                if (((ComponentBase)conf).uid.equals(uid)) {
                    nameRef.set(name);
                    return false;
                }
                return true;
            }
        });
        String name = (String)nameRef.get();
        this.getChildMap().remove((Object)name);
    }

    public Collection<T> getChildren() {
        if (this.getChildMap() == null) {
            return Collections.emptyList();
        }
        return this.getChildMap().values();
    }

    public T getChild(String name) {
        if (this.getChildMap() == null) {
            return null;
        }
        return (T)((ComponentBase)this.getChildMap().get((Object)name));
    }

    public THashMap<String, T> setChildMapAndReturnOld(THashMap<String, T> newChildMap) {
        THashMap<String, T> oldChildMap = this.getChildMap();
        this.setChildMap(newChildMap);
        return oldChildMap;
    }

    public int getModuleId() {
        return this.componentId;
    }

    public String getUid() {
        return this.uid;
    }

    public void setModuleId(int moduleId) {
        this.componentId = moduleId;
    }

    public void setUid(String uid) {
        this.uid = uid;
    }

    public boolean isComposite() {
        return this.getChildMap() != null;
    }

    public void printConfiguration(int indentation) {
        this.printConfiguration(new PrintWriter(System.out), indentation);
    }

    public void printConfiguration(final PrintWriter out, final int indentation) {
        out.print(String.valueOf(this.uid) + " " + this.solverComponentName + "(" + this.componentId + ")");
        if (this.attached) {
            out.print(" (attached)");
        }
        out.println();
        if (this.getChildMap() != null) {
            this.getChildMap().forEachEntry(new TObjectObjectProcedure<String, T>(){

                public boolean execute(String a, T b) {
                    int i = 0;
                    while (i < indentation) {
                        out.print("    ");
                        ++i;
                    }
                    out.print(String.valueOf(a) + " ");
                    ((ComponentBase)b).printConfiguration(out, indentation + 1);
                    return true;
                }
            });
        }
    }

    public void clearParent() {
        this.parent = null;
    }

    public T getParent() {
        return this.parent;
    }

    public void mapModuleIds(final int[] idMap) {
        if (this.componentId > 0) {
            this.componentId = idMap[this.componentId];
        }
        if (this.getChildMap() != null) {
            this.getChildMap().forEachValue(new TObjectProcedure<T>(){

                public boolean execute(T component) {
                    ((ComponentBase)component).mapModuleIds(idMap);
                    return true;
                }
            });
        }
    }

    public abstract THashMap<String, T> getChildMap();

    public abstract void setChildMap(THashMap<String, T> var1);

    public int componentHashCode() {
        return this.hashCode();
    }

    public boolean componentEquals(Object obj) {
        return this.equals(obj);
    }
}

