/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.structural.synchronization.base;

import gnu.trove.map.hash.THashMap;
import gnu.trove.set.hash.THashSet;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.Queue;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.adapter.AdaptException;
import org.simantics.databoard.binding.Binding;
import org.simantics.structural.synchronization.base.ModuleUpdateContext;
import org.simantics.structural.synchronization.base.ModuleUpdaterBase;
import org.simantics.structural.synchronization.base.ModuleUpdaterFactoryBase;
import org.simantics.structural.synchronization.base.ReferenceResolverBase;
import org.simantics.structural.synchronization.base.SolverNameUtil;
import org.simantics.structural.synchronization.internal.Policy;
import org.simantics.structural.synchronization.protocol.ChildInfo;
import org.simantics.structural.synchronization.protocol.Connection;
import org.simantics.structural.synchronization.protocol.SerializedVariable;
import org.simantics.structural.synchronization.protocol.SynchronizationEventHandler;
import org.simantics.structural.synchronization.protocol.SynchronizationException;
import org.simantics.structural.synchronization.utils.ComponentBase;
import org.simantics.structural.synchronization.utils.ComponentFactory;
import org.simantics.structural.synchronization.utils.MappingBase;
import org.simantics.structural.synchronization.utils.Solver;
import org.slf4j.Logger;

public abstract class SynchronizationEventHandlerBase<T extends ComponentBase<T>>
implements SynchronizationEventHandler {
    public static final boolean TRACE_EVENTS = false;
    public final Solver solver;
    protected final SolverNameUtil nameUtil;
    protected final MappingBase<T> mapping;
    final ModuleUpdaterFactoryBase<T> moduleUpdaterFactory;
    final ComponentFactory<T> componentFactory;
    public final ReferenceResolverBase<T> resolver;
    private boolean didChanges = false;
    protected T component;
    THashMap<String, ModuleUpdaterBase<T>> moduleUpdaters = new THashMap();
    Queue<Runnable> postSynchronizationActions = new ArrayDeque<Runnable>();
    protected THashMap<String, T> solverComponentNameToComponent = new THashMap();
    THashSet<T> potentiallyUpdatedComponents = new THashSet();
    protected boolean isUndo = true;

    public SynchronizationEventHandlerBase(Solver solver, ReferenceResolverBase<T> resolver, SolverNameUtil nameUtil, ComponentFactory<T> componentFactory, ModuleUpdaterFactoryBase<T> moduleUpdaterFactory, MappingBase<T> mapping) {
        this.solver = solver;
        this.nameUtil = nameUtil;
        this.mapping = mapping;
        this.componentFactory = componentFactory;
        this.moduleUpdaterFactory = moduleUpdaterFactory;
        this.resolver = resolver;
    }

    public void setAsUndo(boolean isUndo) {
        this.isUndo = isUndo;
    }

    @Override
    public void beginSynchronization() {
        this.component = null;
    }

    @Override
    public void endSynchronization() {
        try {
            Runnable action;
            if (this.component != null) {
                throw new SynchronizationException("beginComponent/endComponent calls do not match.");
            }
            this.resolver.resolvePendingSelfReferences();
            this.resolver.printPending();
            this.mapping.removePending(this.solver);
            while ((action = this.postSynchronizationActions.poll()) != null) {
                action.run();
            }
            this.nameUtil.applySuggestedNames((creationName, newName) -> {
                ComponentBase component = (ComponentBase)this.solverComponentNameToComponent.get(creationName);
                if (component != null) {
                    this.mapping.changeSolverName(component, (String)newName);
                }
            });
            this.solverComponentNameToComponent.clear();
        }
        catch (Throwable e) {
            Policy.logError(e);
            throw new SynchronizationException(e);
        }
    }

    private boolean isAttached(Collection<SerializedVariable> properties) {
        for (SerializedVariable property : properties) {
            if (!property.name.equals("IsAttached")) continue;
            try {
                return (Boolean)property.value.getValue((Binding)Bindings.BOOLEAN);
            }
            catch (AdaptException e) {
                throw new SynchronizationException(e);
            }
        }
        return false;
    }

    private boolean isDesynchronized(Collection<SerializedVariable> properties) {
        for (SerializedVariable property : properties) {
            if (!property.name.equals("IsDesynchronized")) continue;
            try {
                return (Boolean)property.value.getValue((Binding)Bindings.BOOLEAN);
            }
            catch (AdaptException e) {
                throw new SynchronizationException(e);
            }
        }
        return false;
    }

    @Override
    public void beginComponent(String name, String typeId, Collection<SerializedVariable> properties, Collection<Connection> connections, Collection<ChildInfo> children) throws SynchronizationException {
        block39: {
            try {
                boolean attached;
                String parentSolverComponentName;
                if (this.component == null) {
                    name = "COMP_ROOT";
                    parentSolverComponentName = "";
                    this.component = this.mapping.getConfiguration();
                    ((ComponentBase)this.component).setModuleId(this.solver.getId(name));
                    ((ComponentBase)this.component).solverComponentName = name;
                } else {
                    parentSolverComponentName = ((ComponentBase)this.component).solverComponentName;
                    this.component = ((ComponentBase)this.component).getChild(name);
                    if (this.component == null) {
                        throw new SynchronizationException("Didn't find '" + name + "'. " + "It should have been mentioned as a child in the parent beginComponent method.");
                    }
                }
                this.potentiallyUpdatedComponents.remove(this.component);
                ModuleUpdaterBase updater = null;
                if (typeId != null && (updater = (ModuleUpdaterBase)this.moduleUpdaters.get((Object)typeId)) == null) {
                    throw new SynchronizationException("Undefined typeId " + typeId + ".");
                }
                if (typeId == null || updater.isUserComponent || updater.isComposite) {
                    Object oldChildMap;
                    THashMap newChildMap;
                    int moduleId = ((ComponentBase)this.component).getModuleId();
                    boolean justCreated = false;
                    if (!this.isAttached(properties)) {
                        if (moduleId <= 0) {
                            String subprocessName = this.nameUtil.getFreshName(parentSolverComponentName, this.getSubprocessName(name, properties));
                            try {
                                this.solver.addSubprocess(subprocessName, updater.subprocessType);
                            }
                            catch (Exception e) {
                                this.reportProblem("Exception while adding subprocess.", e);
                            }
                            moduleId = this.solver.getId(subprocessName);
                            if (moduleId <= 0) {
                                throw new SynchronizationException("Failed to create a subprocess " + subprocessName);
                            }
                            ((ComponentBase)this.component).setModuleId(moduleId);
                            if (((ComponentBase)this.component).getParent() != null) {
                                int nearestParentId = SynchronizationEventHandlerBase.getNearestParentComponentId(this.component);
                                if (nearestParentId <= 0) {
                                    throw new SynchronizationException("Could not find parent with non-zero component id from Component(" + name + ", " + (this.component != null ? ((ComponentBase)this.component).uid : "null") + "," + typeId + ")");
                                }
                                String parentName = this.solver.getName(nearestParentId);
                                this.solver.includeSubprocess(parentName, subprocessName);
                                ((ComponentBase)this.component).solverComponentName = subprocessName;
                                this.solverComponentNameToComponent.put((Object)subprocessName, this.component);
                            }
                            if (updater.isComposite) {
                                ModuleUpdateContext<T> context = new ModuleUpdateContext<T>(this, updater, this.component);
                                updater.create(context, properties, connections);
                            }
                            justCreated = true;
                        } else {
                            this.mapping.changeSolverName(this.component, this.nameUtil.ensureNameIsVariationOf(parentSolverComponentName, moduleId, this.getSubprocessName(name, properties)));
                            if (updater.isComposite) {
                                ModuleUpdateContext<T> context = new ModuleUpdateContext<T>(this, updater, this.component);
                                updater.update(context, properties, connections);
                            }
                        }
                    }
                    if (this.mapping.getTrustUids()) {
                        newChildMap = new THashMap();
                        for (ChildInfo info : children) {
                            T conf = this.mapping.detachOrCreateComponent(info.uid);
                            newChildMap.put((Object)info.name, conf);
                            this.resolver.markPending(conf);
                            this.potentiallyUpdatedComponents.add(conf);
                        }
                        oldChildMap = ((ComponentBase)this.component).setChildMapAndReturnOld(newChildMap);
                        this.resolver.unmarkPending(this.component);
                        if (oldChildMap != null) {
                            for (ComponentBase component : oldChildMap.values()) {
                                component.clearParent();
                                this.addPendingRemoval(component);
                            }
                        }
                    } else {
                        newChildMap = new THashMap();
                        oldChildMap = ((ComponentBase)this.component).getChildMap();
                        if (oldChildMap == null) {
                            oldChildMap = Collections.emptyMap();
                        }
                        for (ChildInfo info : children) {
                            ComponentBase conf = (ComponentBase)oldChildMap.remove(info.name);
                            if (conf == null) {
                                conf = this.componentFactory.create(info.uid);
                            } else {
                                conf.uid = info.uid;
                            }
                            newChildMap.put((Object)info.name, (Object)conf);
                            this.resolver.markPending(conf);
                        }
                        ((ComponentBase)this.component).setChildMap(newChildMap);
                        this.resolver.unmarkPending(this.component);
                        if (oldChildMap != null) {
                            for (ComponentBase component : oldChildMap.values()) {
                                component.clearParent();
                                this.addPendingRemoval(component);
                            }
                        }
                    }
                    this.postCompositeAction(justCreated, properties, connections, updater);
                    break block39;
                }
                if (!children.isEmpty()) {
                    throw new SynchronizationException("Component with type " + typeId + " cannot have children.");
                }
                ((ComponentBase)this.component).attached = attached = this.isAttached(properties);
                final ModuleUpdateContext<T> context = new ModuleUpdateContext<T>(this, updater, this.component);
                int moduleId = ((ComponentBase)this.component).getModuleId();
                if (moduleId <= 0) {
                    if (attached) {
                        ((ComponentBase)this.component).attached = true;
                        context.setModuleName(name);
                        context.setModuleId(this.solver.getId(name));
                        if (context.getModuleId() <= 0) {
                            this.reportProblem("Didn't find attached module " + name + ".");
                        } else if (!this.isDesynchronized(properties)) {
                            updater.update(context, properties, connections);
                        }
                        this.setDidChanges();
                    } else {
                        ((ComponentBase)this.component).attached = false;
                        context.setModuleName(this.nameUtil.getFreshName(parentSolverComponentName, name));
                        if (this.isUndo) {
                            context.addPostUpdateAction(new Runnable(){

                                @Override
                                public void run() {
                                    context.stateLoadedFromUndo = SynchronizationEventHandlerBase.this.mapping.undoContext.loadState(SynchronizationEventHandlerBase.this.solver, ((ComponentBase)context.component).componentId, ((ComponentBase)context.component).uid);
                                }
                            });
                        }
                        updater.create(context, properties, connections);
                        this.solverComponentNameToComponent.put((Object)context.getModuleName(), this.component);
                    }
                } else if (!this.isDesynchronized(properties)) {
                    String newName = this.nameUtil.ensureNameIsVariationOf(parentSolverComponentName, moduleId, name);
                    this.mapping.changeSolverName(this.component, newName);
                    context.setModuleName(newName);
                    updater.update(context, properties, connections);
                } else {
                    this.resolver.unmarkPending(this.component);
                }
            }
            catch (Throwable e) {
                Policy.logError(e);
                throw new SynchronizationException(e);
            }
        }
    }

    private static int getNearestParentComponentId(ComponentBase<?> component) {
        Object parent = component.getParent();
        while (parent != null) {
            int pid = ((ComponentBase)parent).getModuleId();
            if (pid > 0) {
                return pid;
            }
            parent = ((ComponentBase)parent).getParent();
        }
        return -1;
    }

    protected void addPendingRemoval(T component) {
        this.mapping.addPendingRemoval(component);
    }

    private String getSubprocessName(String name, Collection<SerializedVariable> properties) {
        for (SerializedVariable property : properties) {
            if (!property.name.equals("HasSubprocessName")) continue;
            try {
                String value = (String)property.value.getValue((Binding)Bindings.STRING);
                if (value.isEmpty()) continue;
                return value;
            }
            catch (AdaptException e) {
                e.printStackTrace();
                break;
            }
        }
        return name;
    }

    @Override
    public void endComponent() {
        try {
            if (this.component == null) {
                return;
            }
            for (ComponentBase child : ((ComponentBase)this.component).getChildren()) {
                if (!this.potentiallyUpdatedComponents.remove((Object)child)) continue;
                this.resolver.unmarkPending(child);
            }
            Object parent = ((ComponentBase)this.component).getParent();
            if (parent == null && this.mapping.getConfiguration() != this.component) {
                throw new SynchronizationException("BUG: beginComponent/endComponent calls do not match.");
            }
            this.component = parent;
        }
        catch (Throwable e) {
            Policy.logError(e);
            throw new SynchronizationException(e);
        }
    }

    @Override
    public void beginType(String id, Collection<SerializedVariable> properties) {
        try {
            ModuleUpdaterBase<T> updater;
            try {
                updater = this.moduleUpdaterFactory.createUpdater(id);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            if (updater == null) {
                throw new SynchronizationException("Failed to create module updater for id " + id + ".");
            }
            this.moduleUpdaters.put((Object)id, updater);
        }
        catch (Throwable e) {
            Policy.logError(e);
            throw new SynchronizationException(e);
        }
    }

    @Override
    public void endType() {
    }

    public boolean getDidChanges() {
        return this.didChanges;
    }

    public void setDidChanges() {
        this.didChanges = true;
    }

    @Override
    public void reportProblem(String description) {
        this.getLogger().error(description);
    }

    @Override
    public void reportProblem(String description, Exception e) {
        this.getLogger().error(description, (Throwable)e);
    }

    public void addPostSynchronizationAction(Runnable action) {
        this.postSynchronizationActions.add(action);
    }

    protected void postCompositeAction(boolean justCreated, Collection<SerializedVariable> properties, Collection<Connection> connections, ModuleUpdaterBase<T> updater) throws Exception {
    }

    public long getFromRevision() {
        return this.mapping.currentRevision;
    }

    public abstract Logger getLogger();
}

