/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.views;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;
import org.simantics.databoard.util.StreamUtil;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.common.utils.ListUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.scenegraph.loader.ScenegraphLoaderUtils;
import org.simantics.scl.reflection.annotations.SCLValue;
import org.simantics.views.ViewUtils;
import org.simantics.views.ontology.ViewsResources;

public class All {
    @SCLValue(type="ReadGraph -> Resource -> Variable -> a")
    public static Object resourceURI(ReadGraph graph, Resource converter, Variable context) throws DatabaseException {
        ViewsResources VIEW = ViewsResources.getInstance((ReadGraph)graph);
        Resource resource = graph.getSingleObject(converter, VIEW.ResourceURI_HasResource);
        return graph.getURI(resource);
    }

    @SCLValue(type="ReadGraph -> Resource -> Variable -> a")
    public static Object parameterValue(ReadGraph graph, Resource converter, Variable context) throws DatabaseException {
        Variable runtime = ScenegraphLoaderUtils.getRuntimeVariable((ReadGraph)graph, (Variable)context);
        Variable base = ScenegraphLoaderUtils.getBaseVariable((ReadGraph)graph, (Variable)context);
        String rvi = context.getURI(graph).substring(base.getURI(graph).length());
        Variable parameter = runtime.browse(graph, rvi);
        return parameter.getValue(graph);
    }

    @SCLValue(type="ReadGraph -> Resource -> Variable -> Resource")
    public static Resource singleResourceSelection(ReadGraph graph, Resource resource, Variable context) throws DatabaseException {
        return ScenegraphLoaderUtils.getPossibleResourceSelection((ReadGraph)graph, (Variable)context);
    }

    @SCLValue(type="ReadGraph -> Resource -> Variable -> [String]")
    public static List<String> tabChildNames(ReadGraph graph, Resource converter, Variable context) throws DatabaseException {
        Collection children = context.getParent(graph).getChildren(graph);
        ArrayList<String> result = new ArrayList<String>();
        for (Variable child : children) {
            String label = (String)child.getPropertyValue(graph, "HasLabel");
            result.add(label);
        }
        return result;
    }

    @SCLValue(type="ReadGraph -> Resource -> Variable -> a")
    public static Object bundleImage(ReadGraph graph, Resource converter, Variable context) throws DatabaseException {
        ViewsResources VIEW = ViewsResources.getInstance((ReadGraph)graph);
        String reference = (String)graph.getRelatedValue(converter, VIEW.BundleImage_HasReference);
        String[] parts = reference.split(":");
        if (parts.length != 2) {
            return null;
        }
        Bundle bundle = Platform.getBundle((String)parts[0]);
        if (bundle == null) {
            throw new IllegalArgumentException("null bundle");
        }
        URL fullPathString = FileLocator.find((Bundle)bundle, (IPath)new Path(parts[1]), null);
        if (fullPathString == null) {
            try {
                fullPathString = new URL(parts[1]);
            }
            catch (MalformedURLException malformedURLException) {
                return null;
            }
        }
        try {
            return StreamUtil.readFully((InputStream)fullPathString.openStream());
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    @SCLValue(type="ReadGraph -> Resource -> Variable -> a")
    public static Object gridData(ReadGraph graph, Resource converter, Variable context) throws DatabaseException {
        return ViewUtils.getGridData((RequestProcessor)graph, converter);
    }

    @SCLValue(type="ReadGraph -> Resource -> Variable -> a")
    public static Object gridLayout(ReadGraph graph, Resource converter, Variable context) throws DatabaseException {
        return ViewUtils.getLayout((RequestProcessor)graph, converter);
    }

    @SCLValue(type="ReadGraph -> Resource -> Variable -> a")
    public static Object rowData(ReadGraph graph, Resource converter, Variable context) throws DatabaseException {
        return ViewUtils.getRowData((RequestProcessor)graph, converter);
    }

    @SCLValue(type="ReadGraph -> Resource -> Variable -> a")
    public static Object rowLayout(ReadGraph graph, Resource converter, Variable context) throws DatabaseException {
        return ViewUtils.getRowLayout((RequestProcessor)graph, converter);
    }

    @SCLValue(type="ReadGraph -> Resource -> Variable -> a")
    public static Object style(ReadGraph graph, Resource converter, Variable context) throws DatabaseException {
        return ViewUtils.getStyle((RequestProcessor)graph, converter);
    }

    @SCLValue(type="ReadGraph -> Resource -> a -> b")
    public static Object columnList(ReadGraph graph, Resource resource, Object context) throws DatabaseException {
        ArrayList<ViewUtils.ColumnBean> result = new ArrayList<ViewUtils.ColumnBean>();
        for (Resource item : ListUtils.toList((ReadGraph)graph, (Resource)resource)) {
            result.add(ViewUtils.getColumn((RequestProcessor)graph, item));
        }
        return result;
    }
}

