/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.impl.query;

import gnu.trove.ext.IdentityHashSet;
import gnu.trove.map.hash.THashMap;
import gnu.trove.set.hash.THashSet;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.simantics.db.debug.ListenerReport;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.impl.graph.ReadGraphImpl;
import org.simantics.db.impl.query.CacheCollectionResult;
import org.simantics.db.impl.query.CacheEntry;
import org.simantics.db.impl.query.CacheEntryBase;
import org.simantics.db.impl.query.ExternalReadEntry;
import org.simantics.db.impl.query.ListenerEntry;
import org.simantics.db.impl.query.Query;
import org.simantics.db.impl.query.QueryProcessor;
import org.simantics.db.impl.query.Scheduler;
import org.simantics.db.impl.query.UpdateEntry;
import org.simantics.db.procedure.ListenerBase;
import org.simantics.utils.datastructures.Pair;
import org.simantics.utils.datastructures.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryListening {
    static final Logger LOGGER = LoggerFactory.getLogger(QueryListening.class);
    private final QueryProcessor processor;
    private final Scheduler scheduler;
    private final Map<ListenerBase, ListenerEntry> addedEntries = new HashMap<ListenerBase, ListenerEntry>();
    private THashSet<ListenerEntry> scheduledListeners = new THashSet();
    private boolean firingListeners = false;
    final Map<CacheEntry, Object> parents = new IdentityHashMap<CacheEntry, Object>();
    final THashMap<CacheEntry, ArrayList<ListenerEntry>> listeners = new THashMap(10, 0.75f);
    private static final CacheEntry REMOVED = new CacheEntryBase<Object>(){

        @Override
        int makeHash() {
            return 0;
        }

        @Override
        Query getQuery() {
            return null;
        }

        @Override
        Object performFromCache(ReadGraphImpl graph, Object procedure) throws DatabaseException {
            return null;
        }
    };
    private static List<CacheEntry> NO_PARENTS_ARRAY = List.of();

    QueryListening(QueryProcessor processor) {
        this.processor = processor;
        this.scheduler = new Scheduler(processor);
        this.scheduler.start();
    }

    public boolean hasScheduledUpdates() {
        return !this.scheduledListeners.isEmpty();
    }

    void stopThreading() {
        try {
            this.scheduler.sync();
            int check = this.scheduler.singleThreadRequested.getAndIncrement();
            if (check > 0) {
                LOGGER.error("Problem in query listening bookkeeping", (Throwable)new Exception());
            }
        }
        catch (Throwable t) {
            LOGGER.error("Error while waiting for query dependency management", t);
        }
    }

    void startThreading() {
        try {
            int check = this.scheduler.singleThreadRequested.decrementAndGet();
            if (check > 0) {
                LOGGER.error("Problem in query listening bookkeeping", (Throwable)new Exception());
            }
        }
        catch (Throwable t) {
            LOGGER.error("Error while waiting for query dependency management", t);
        }
    }

    void registerDependencies(ReadGraphImpl graph, CacheEntry child, CacheEntry parent, ListenerBase listener, Object procedure, boolean inferred) {
        if (inferred) {
            assert (listener == null);
            return;
        }
        if (parent != null) {
            try {
                if (!child.isImmutable(graph) && !parent.isImmutable(graph)) {
                    this.scheduler.accept(new RegisterParentRunnable(graph.processor.listening, parent, child));
                }
            }
            catch (DatabaseException e) {
                LOGGER.error("Error while registering query dependencies", (Throwable)e);
            }
        }
        if (listener != null && !listener.safeIsDisposed()) {
            this.scheduler.accept(new RegisterListenerRunnable(this, listener, procedure, parent, child));
        }
    }

    void registerFirstKnown(ListenerBase base, Object result) {
        if (base == null) {
            return;
        }
        this.scheduler.accept(new RegisterFirstKnownRunnable(this.addedEntries, base, result));
    }

    void scheduleListener(ListenerEntry entry) {
        assert (entry != null);
        this.scheduledListeners.add((Object)entry);
    }

    boolean hasListener(CacheEntry entry) {
        return this.listeners.get((Object)entry) != null;
    }

    boolean hasListenerAfterDisposing(CacheEntry entry) {
        ArrayList entries = (ArrayList)this.listeners.get((Object)entry);
        if (entries != null) {
            ArrayList<ListenerEntry> list = null;
            int i = 0;
            int n = entries.size();
            while (i < n) {
                ListenerEntry e = (ListenerEntry)entries.get(i);
                if (e.base.safeIsDisposed()) {
                    if (list == null) {
                        list = new ArrayList<ListenerEntry>();
                    }
                    list.add(e);
                }
                ++i;
            }
            if (list != null) {
                i = 0;
                n = list.size();
                while (i < n) {
                    entries.remove(list.get(i));
                    ++i;
                }
            }
            if (entries.isEmpty()) {
                this.listeners.remove((Object)entry);
                return false;
            }
            return true;
        }
        return false;
    }

    void processListenerReport(CacheEntry<?> entry, Map<CacheEntry, Set<ListenerBase>> workarea) {
        if (!workarea.containsKey(entry)) {
            HashSet<ListenerBase> ls = new HashSet<ListenerBase>();
            for (ListenerEntry e : this.getListenerEntries(entry)) {
                ls.add(e.base);
            }
            workarea.put(entry, ls);
            this.forParents(entry, parent -> {
                this.processListenerReport((CacheEntry<?>)parent, workarea);
                ls.addAll((Collection)workarea.get(parent));
            });
        }
    }

    public synchronized ListenerReport getListenerReport() throws IOException {
        class ListenerReportImpl
        implements ListenerReport {
            Map<CacheEntry, Set<ListenerBase>> workarea = new HashMap<CacheEntry, Set<ListenerBase>>();

            ListenerReportImpl() {
            }

            public void print(PrintStream b) {
                HashMap<ListenerBase, Integer> hist = new HashMap<ListenerBase, Integer>();
                for (Map.Entry<CacheEntry, Set<ListenerBase>> e : this.workarea.entrySet()) {
                    Iterator<ListenerBase> iterator = e.getValue().iterator();
                    while (iterator.hasNext()) {
                        ListenerBase l;
                        Integer i = (Integer)hist.get(l = iterator.next());
                        hist.put(l, i != null ? i - 1 : -1);
                    }
                }
                for (Pair p : CollectionUtils.valueSortedEntries(hist)) {
                    b.print(-((Integer)p.second).intValue() + " " + p.first + "\n");
                }
                b.flush();
            }
        }
        ListenerReportImpl result = new ListenerReportImpl();
        Collection<CacheEntryBase> all = this.processor.allCaches(new CacheCollectionResult()).toCollection();
        for (CacheEntryBase entry : all) {
            this.hasListenerAfterDisposing(entry);
        }
        for (CacheEntryBase entry : all) {
            this.processListenerReport(entry, result.workarea);
        }
        return result;
    }

    public synchronized String reportListeners(File file) throws IOException {
        if (!this.processor.isAlive()) {
            return "Disposed!";
        }
        PrintStream b = new PrintStream(new BufferedOutputStream(new FileOutputStream(file)));
        ListenerReport report = this.getListenerReport();
        report.print(b);
        return "Done reporting listeners.";
    }

    public void fireListeners(ReadGraphImpl graph) {
        this.stopThreading();
        ReadGraphImpl listenerGraph = graph.forSyncExecute();
        this.fireListeners_(listenerGraph);
        listenerGraph.asyncBarrier.dec();
        listenerGraph.asyncBarrier.waitBarrier(this, listenerGraph);
        this.startThreading();
    }

    private void fireListeners_(ReadGraphImpl graph) {
        assert (!this.processor.updating);
        assert (!this.processor.cache.collecting);
        assert (!this.firingListeners);
        this.firingListeners = true;
        try {
            while (!this.scheduledListeners.isEmpty()) {
                CacheEntry entry;
                THashSet<ListenerEntry> entries = this.scheduledListeners;
                this.scheduledListeners = new THashSet();
                ArrayList<ListenerEntry> schedule = new ArrayList<ListenerEntry>();
                for (ListenerEntry listenerEntry : entries) {
                    if (this.pruneListener(listenerEntry)) continue;
                    entry = listenerEntry.entry;
                    assert (entry != null);
                    Object newValue = this.processor.compareTo(graph, entry, listenerEntry.getLastKnown());
                    if (newValue == ListenerEntry.NOT_CHANGED) continue;
                    schedule.add(listenerEntry);
                    listenerEntry.setLastKnown(entry.getResult());
                }
                for (ListenerEntry listenerEntry : schedule) {
                    entry = listenerEntry.entry;
                    try {
                        entry.performFromCache(graph, listenerEntry.procedure);
                    }
                    catch (Throwable t) {
                        LOGGER.debug("Unexpected exception ", t);
                    }
                }
            }
            Set<ExternalReadEntry<?>> externalUpdates = this.processor.updatedPrimitivesInCurrentWrite;
            this.processor.updatedPrimitivesInCurrentWrite = new HashSet();
            for (ExternalReadEntry<?> query : externalUpdates) {
                this.pruneParentSet(query);
                if (query.isDiscarded() || this.processor.isBound(query)) continue;
                this.processor.cache.externalReadEntryMap.remove(query.id);
                query.discard();
            }
        }
        finally {
            this.firingListeners = false;
        }
    }

    void updateParents(int indent, CacheEntry entry, Deque<UpdateEntry> todo) {
        this.forParents(entry, parent -> {
            if (!parent.isDiscarded()) {
                todo.push(new UpdateEntry(entry, (CacheEntry)parent, indent + 2));
            }
        });
    }

    void updateParent(int indent, CacheEntry entry, CacheEntry parent, Deque<UpdateEntry> todo) {
        if (!parent.isDiscarded()) {
            todo.push(new UpdateEntry(entry, parent, indent + 2));
        }
    }

    private boolean pruneListener(ListenerEntry entry) {
        if (entry.base.safeIsDisposed()) {
            assert (entry != null);
            ArrayList list = (ArrayList)this.listeners.get((Object)entry.entry);
            if (list != null) {
                boolean success = list.remove(entry);
                assert (success);
                if (list.isEmpty()) {
                    this.listeners.remove((Object)entry.entry);
                }
            }
            return true;
        }
        return false;
    }

    private List<ListenerEntry> getListenerEntries(CacheEntry entry) {
        this.hasListenerAfterDisposing(entry);
        if (this.listeners.get((Object)entry) != null) {
            return (List)this.listeners.get((Object)entry);
        }
        return Collections.emptyList();
    }

    public void addParent(CacheEntry entry, CacheEntry parent) {
        Object result = this.parents.get(entry);
        if (result == null) {
            this.parents.put(entry, parent);
            return;
        }
        if (result instanceof CacheEntry) {
            CacheEntry single = (CacheEntry)result;
            if (single.isDiscarded()) {
                this.parents.put(entry, parent);
            } else {
                IdentityHashSet set = new IdentityHashSet(3, CacheEntry.class, (Object)REMOVED);
                set.add((Object)single);
                set.add((Object)parent);
                this.parents.put(entry, set);
            }
        } else {
            IdentityHashSet set = (IdentityHashSet)result;
            set.add((Object)parent);
        }
    }

    public void discarded(CacheEntry entry) {
        this.parents.remove(entry);
    }

    public List<CacheEntry> getParents(CacheEntry entry) {
        Object result = this.parents.get(entry);
        if (result == null) {
            return NO_PARENTS_ARRAY;
        }
        if (result instanceof CacheEntry) {
            return List.of((CacheEntry)result);
        }
        IdentityHashSet set = (IdentityHashSet)result;
        ArrayList<CacheEntry> list = new ArrayList<CacheEntry>(set.size());
        set.values(list::add);
        return list;
    }

    public boolean hasParents(CacheEntry entry) {
        return this.parents.containsKey(entry);
    }

    public void forParents(CacheEntry entry, Consumer<CacheEntry> consumer) {
        Object result = this.parents.get(entry);
        if (result == null) {
            return;
        }
        if (result instanceof CacheEntry) {
            consumer.accept((CacheEntry)result);
        } else {
            IdentityHashSet set = (IdentityHashSet)result;
            set.values(consumer);
        }
    }

    public CacheEntry getFirstParent(CacheEntry entry) {
        Object result = this.parents.get(entry);
        if (result == null) {
            return null;
        }
        if (result instanceof CacheEntry) {
            return (CacheEntry)result;
        }
        IdentityHashSet set = (IdentityHashSet)result;
        return (CacheEntry)set.firstBy(parent -> !parent.isDiscarded());
    }

    public CacheEntry firstParentNotDiscarded(CacheEntry entry) {
        Object result = this.parents.get(entry);
        if (result == null) {
            return null;
        }
        if (result instanceof CacheEntry) {
            CacheEntry parent = (CacheEntry)result;
            if (parent.isDiscarded()) {
                return null;
            }
            return parent;
        }
        IdentityHashSet set = (IdentityHashSet)result;
        return (CacheEntry)set.removeOrGetByPredicate(CacheEntry::isDiscarded);
    }

    public void pruneParentSet(CacheEntry entry) {
        Object result = this.parents.get(entry);
        if (result == null) {
            return;
        }
        if (result instanceof CacheEntry) {
            CacheEntry parent = (CacheEntry)result;
            if (parent.isDiscarded()) {
                this.parents.remove(entry);
            }
        } else {
            IdentityHashSet set = (IdentityHashSet)result;
            int size = set.removeBy(CacheEntry::isDiscarded);
            if (size == 1) {
                this.parents.put(entry, set.first());
            } else if (size == 0) {
                this.parents.remove(entry);
            }
        }
    }

    public boolean removeParent(CacheEntry entry, CacheEntry parent) {
        Object result = this.parents.get(entry);
        if (result == null) {
            return false;
        }
        if (result instanceof CacheEntry) {
            if (parent == result) {
                this.parents.remove(entry);
                return true;
            }
            return false;
        }
        IdentityHashSet set = (IdentityHashSet)result;
        boolean removed = set.remove((Object)parent);
        if (removed) {
            int size = set.size();
            if (size == 1) {
                this.parents.put(entry, set.first());
            } else if (size == 0) {
                this.parents.remove(entry);
            }
            return true;
        }
        return false;
    }

    private static class RegisterFirstKnownRunnable
    implements Runnable {
        private final Map<ListenerBase, ListenerEntry> addedEntries;
        private final ListenerBase base;
        private final Object result;

        public RegisterFirstKnownRunnable(Map<ListenerBase, ListenerEntry> addedEntries, ListenerBase base, Object result) {
            this.addedEntries = addedEntries;
            this.base = base;
            this.result = result;
        }

        @Override
        public void run() {
            ListenerEntry entry = this.addedEntries.remove(this.base);
            if (entry != null) {
                entry.setLastKnown(this.result);
            }
        }
    }

    private static class RegisterListenerRunnable
    implements Runnable {
        private final QueryListening queryListening;
        private final ListenerBase base;
        private final Object procedure;
        private final CacheEntry parent;
        private final CacheEntry entry;

        public RegisterListenerRunnable(QueryListening queryListening, ListenerBase base, Object procedure, CacheEntry parent, CacheEntry entry) {
            this.queryListening = queryListening;
            this.base = base;
            this.procedure = procedure;
            this.parent = parent;
            this.entry = entry;
        }

        @Override
        public void run() {
            ListenerEntry result;
            int currentIndex;
            assert (this.entry != null);
            assert (this.procedure != null);
            ArrayList<ListenerEntry> list = (ArrayList<ListenerEntry>)this.queryListening.listeners.get((Object)this.entry);
            if (list == null) {
                list = new ArrayList<ListenerEntry>(1);
                this.queryListening.listeners.put((Object)this.entry, list);
            }
            if ((currentIndex = list.indexOf(result = new ListenerEntry(this.entry, this.base, this.procedure))) > -1) {
                ListenerEntry current = (ListenerEntry)list.get(currentIndex);
                if (!current.base.safeIsDisposed()) {
                    return;
                }
                list.set(currentIndex, result);
            } else {
                list.add(result);
            }
            this.queryListening.addedEntries.put(this.base, result);
        }
    }

    private static class RegisterParentRunnable
    implements Runnable {
        private final QueryListening listening;
        private final CacheEntry parent;
        private final CacheEntry child;

        public RegisterParentRunnable(QueryListening listening, CacheEntry parent, CacheEntry child) {
            this.listening = listening;
            this.parent = parent;
            this.child = child;
        }

        @Override
        public void run() {
            this.listening.addParent(this.child, this.parent);
        }
    }
}

