/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.impl.procedure;

import java.util.concurrent.atomic.AtomicBoolean;
import org.simantics.db.AsyncReadGraph;
import org.simantics.db.common.utils.Logger;
import org.simantics.db.procedure.AsyncProcedure;

public class CallWrappedSingleQueryProcedure4<Result>
implements AsyncProcedure<Result> {
    private final Object key;
    private final AsyncProcedure<Result> procedure;
    private final AtomicBoolean latch = new AtomicBoolean(false);

    public CallWrappedSingleQueryProcedure4(AsyncProcedure<Result> procedure, Object key) {
        this.procedure = procedure;
        this.key = key;
    }

    public void execute(AsyncReadGraph graph, Result result) {
        if (this.latch.compareAndSet(false, true)) {
            try {
                this.procedure.execute(graph, result);
            }
            catch (Throwable t) {
                Logger.defaultLogError((String)("AsyncProcedure.exception failed for " + this.procedure), (Throwable)t);
            }
        } else {
            Logger.defaultLogError((String)"Execute or exception was called many times (this time is execute)");
        }
    }

    public void exception(AsyncReadGraph graph, Throwable t) {
        if (this.latch.compareAndSet(false, true)) {
            try {
                this.procedure.exception(graph, t);
            }
            catch (Throwable throwable) {
                Logger.defaultLogError((String)("AsyncProcedure.exception failed for " + this.procedure), (Throwable)throwable);
            }
        } else {
            Logger.defaultLogError((String)"Execute or exception was called many times (this time is exception)");
        }
    }
}

