/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.impl.graph;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.simantics.db.impl.BlockingAsyncProcedure;
import org.simantics.db.impl.graph.AsyncBarrierImpl;
import org.simantics.db.impl.query.CacheEntry;
import org.simantics.db.impl.query.QueryProcessor;

public class BarrierTracing {
    public static final boolean BOOKKEEPING = false;
    static final boolean RESTART_GUARD = false;
    public static Map<QueryProcessor.SessionTask, Exception> tasks = new HashMap<QueryProcessor.SessionTask, Exception>();
    public static final HashMap<AsyncBarrierImpl, Collection<AsyncBarrierImpl>> reverseLookup = new HashMap();
    public static final HashMap<AsyncBarrierImpl, Debugger> debuggerMap = new HashMap();
    public static final HashMap<AsyncBarrierImpl, Throwable> restartMap = new HashMap();
    public static final HashMap<AsyncBarrierImpl, Throwable> startMap = new HashMap();
    public static final HashMap<BlockingAsyncProcedure, Throwable> baps = new HashMap();

    public static synchronized void registerBAP(BlockingAsyncProcedure bap) {
        baps.put(bap, new Exception());
    }

    public static synchronized void unregisterBAP(BlockingAsyncProcedure bap) {
        baps.remove(bap);
    }

    public static synchronized void printBAPS() {
        for (BlockingAsyncProcedure bap : baps.keySet()) {
            bap.print();
            Throwable t = baps.get(bap);
            if (t == null) continue;
            t.printStackTrace();
        }
    }

    public static synchronized void report() {
        for (Map.Entry<AsyncBarrierImpl, Debugger> entry : debuggerMap.entrySet()) {
            AsyncBarrierImpl barrier = entry.getKey();
            if (barrier.get() == 0) continue;
            Debugger d = entry.getValue();
            d.print();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void trace(AsyncBarrierImpl barrier, CacheEntry<?> entry) {
        HashMap<AsyncBarrierImpl, Object> hashMap = debuggerMap;
        synchronized (hashMap) {
            debuggerMap.put(barrier, new Debugger(entry));
        }
        hashMap = reverseLookup;
        synchronized (hashMap) {
            Collection<AsyncBarrierImpl> barriers = reverseLookup.get(barrier.caller);
            if (barriers == null) {
                barriers = new ArrayList<AsyncBarrierImpl>();
                reverseLookup.put(barrier.caller, barriers);
            }
            barriers.add(barrier);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void inc(AsyncBarrierImpl barrier, int count, Object id) {
        HashMap<AsyncBarrierImpl, Debugger> hashMap = debuggerMap;
        synchronized (hashMap) {
            Debugger debugger = debuggerMap.get(barrier);
            debugger.inc(id + " => " + count);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dec(AsyncBarrierImpl barrier, int count, Object id) {
        Debugger debugger;
        HashMap<AsyncBarrierImpl, Debugger> hashMap = debuggerMap;
        synchronized (hashMap) {
            debugger = debuggerMap.get(barrier);
            debugger.dec(id + " => " + count);
        }
        if (count != 0 && count < 0) {
            hashMap = debuggerMap;
            synchronized (hashMap) {
                debugger = debuggerMap.get(barrier);
                debugger.print();
            }
            startMap.get(barrier).printStackTrace();
            restartMap.get(barrier).printStackTrace();
            new Exception().printStackTrace();
        }
    }

    public static class Debugger {
        Object entry;
        List<Exception> exceptions = new ArrayList<Exception>();

        Debugger(Object entry) {
            this.entry = entry;
            this.exceptions.add(new Exception());
        }

        public synchronized void inc(String message) {
            this.exceptions.add(new Exception(message));
        }

        public synchronized void dec(String message) {
            this.exceptions.add(new Exception(message));
        }

        public synchronized void print() {
            System.err.println("Printing barrier invocation log with " + this.exceptions.size() + " elements " + this.entry);
            this.exceptions.add(new Exception(" = DONE ="));
            for (Exception e : this.exceptions) {
                e.printStackTrace();
            }
        }
    }
}

