/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.debug.browser.content;

import java.util.Arrays;
import java.util.Comparator;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;
import org.simantics.debug.browser.content.ResourceBrowserRewriter;
import org.simantics.debug.browser.internal.Activator;

public class ResourceBrowserRewriterRepository {
    private static ServiceTracker<ResourceBrowserRewriter, ResourceBrowserRewriter> TRACKER;
    private static final Comparator<ResourceBrowserRewriter> REWRITER_COMPARATOR;

    static {
        REWRITER_COMPARATOR = new Comparator<ResourceBrowserRewriter>(){

            @Override
            public int compare(ResourceBrowserRewriter o1, ResourceBrowserRewriter o2) {
                return Double.compare(o1.getPriority(), o2.getPriority());
            }
        };
    }

    public static ResourceBrowserRewriter[] getRewriters() {
        if (TRACKER == null) {
            BundleContext context = Activator.getContext();
            TRACKER = new ServiceTracker(context, ResourceBrowserRewriter.class, null);
            TRACKER.open();
        }
        ResourceBrowserRewriter[] rewriters = (ResourceBrowserRewriter[])TRACKER.getServices((Object[])new ResourceBrowserRewriter[TRACKER.getTrackingCount()]);
        Arrays.sort(rewriters, REWRITER_COMPARATOR);
        return rewriters;
    }
}

