/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.graph.refactoring;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.adapter.AdaptException;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.error.BindingException;
import org.simantics.databoard.binding.mutable.Variant;
import org.simantics.databoard.container.DataContainer;
import org.simantics.databoard.container.DataContainers;
import org.simantics.graph.representation.TransferableGraph1;

public class TransferableGraphHasher {
    public static int hashTG(TransferableGraph1 tg) throws BindingException {
        return TransferableGraph1.BINDING.hashValue((Object)tg);
    }

    public static DataContainer addHashToTG(DataContainer tgContainer, TransferableGraph1 tg) throws BindingException {
        Binding tgb = TransferableGraph1.BINDING;
        tgContainer.metadata.put("cached.hashcode", new Variant((Binding)Bindings.INTEGER, (Object)TransferableGraphHasher.hashTG(tg)));
        tgContainer.content = new Variant(tgb, (Object)tg);
        return tgContainer;
    }

    public static DataContainer addHashToTG(DataContainer tgContainer) throws BindingException, AdaptException {
        return TransferableGraphHasher.addHashToTG(tgContainer, (TransferableGraph1)tgContainer.content.getValue(TransferableGraph1.BINDING));
    }

    public static void hashTG(Path input, Path output) throws Exception {
        System.out.format("Adding cached hash value to transferable graph%n\t" + input.toString() + "%nto%n\t" + output.toString(), new Object[0]);
        DataContainers.writeFile((File)output.toFile(), (DataContainer)TransferableGraphHasher.addHashToTG(DataContainers.readFile((File)input.toFile(), (Binding)TransferableGraph1.BINDING)));
    }

    public static void main(String[] args) throws Exception {
        if (args.length == 0) {
            System.out.println("Required arguments: <input graph.tg file> [<output .tg file>]");
        } else if (args.length == 1) {
            Path p = Paths.get(args[0], new String[0]);
            TransferableGraphHasher.hashTG(p, p);
        } else {
            TransferableGraphHasher.hashTG(Paths.get(args[0], new String[0]), Paths.get(args[1], new String[0]));
        }
    }
}

