/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.diagram.adapter;

import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import org.simantics.Simantics;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.AsyncReadGraph;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.procedure.guarded.GuardedAsyncProcedureWrapper;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.procedure.AsyncProcedure;
import org.simantics.db.request.WriteInterface;
import org.simantics.diagram.adapter.ElementFactory;
import org.simantics.diagram.adapter.ElementFactoryUtil;
import org.simantics.diagram.adapter.PathElementHandler;
import org.simantics.diagram.adapter.SyncElementFactory;
import org.simantics.diagram.stubs.G2DResource;
import org.simantics.diagram.synchronization.graph.DiagramGraphUtil;
import org.simantics.g2d.canvas.ICanvasContext;
import org.simantics.g2d.diagram.IDiagram;
import org.simantics.g2d.element.ElementClass;
import org.simantics.g2d.element.ElementUtils;
import org.simantics.g2d.element.IElement;
import org.simantics.g2d.element.handler.ElementHandler;
import org.simantics.g2d.element.handler.impl.DefaultTransform;
import org.simantics.g2d.element.handler.impl.RequireImageFocusMode;
import org.simantics.g2d.element.handler.impl.SimpleElementLayers;
import org.simantics.g2d.element.handler.impl.StaticObjectAdapter;
import org.simantics.g2d.element.handler.impl.StaticSymbolImpl;
import org.simantics.g2d.image.DefaultImages;
import org.simantics.g2d.image.Image;
import org.simantics.g2d.svg.SVGImage;
import org.simantics.scenegraph.g2d.nodes.IPathListener;
import org.simantics.scenegraph.g2d.nodes.PathNodeStyle;

public class PathElementClassFactory
extends SyncElementFactory {
    public static final ElementFactory INSTANCE = new PathElementClassFactory();

    @Override
    public ElementClass create(ReadGraph graph, ICanvasContext canvas, IDiagram diagram, Resource elementType) throws DatabaseException {
        String id = "PathElement: " + NameUtils.getSafeName((ReadGraph)graph, (Resource)elementType);
        G2DResource g2d = G2DResource.getInstance((ReadGraph)graph);
        String svgDoc = (String)graph.getPossibleRelatedValue(elementType, g2d.HasSVGDocument);
        Object image = null;
        image = svgDoc != null ? new SVGImage(String.valueOf(id) + ".svg", svgDoc) : (Image)DefaultImages.ERROR_DECORATOR.get();
        return ElementClass.compile((ElementHandler[])new ElementHandler[]{new StaticObjectAdapter((Object)elementType), DefaultTransform.INSTANCE, SimpleElementLayers.INSTANCE, RequireImageFocusMode.INSTANCE, new PathElementHandler(), new StaticSymbolImpl(image)}).setId(id);
    }

    @Override
    public void load(AsyncReadGraph graph, ICanvasContext canvas, IDiagram diagram, Resource elementResource, IElement element, AsyncProcedure<IElement> procedure) {
        GuardedAsyncProcedureWrapper guard = new GuardedAsyncProcedureWrapper(procedure, 2);
        super.load(graph, canvas, diagram, elementResource, element, (AsyncProcedure<IElement>)guard);
        ElementFactoryUtil.loadLayersForElement(graph, diagram, element, elementResource, (AsyncProcedure<IElement>)guard);
    }

    @Override
    public void load(ReadGraph graph, ICanvasContext canvas, IDiagram diagram, final Resource element, IElement e) throws DatabaseException {
        final G2DResource G2D = G2DResource.getInstance((ReadGraph)graph);
        AffineTransform at = DiagramGraphUtil.getAffineTransform(graph, element);
        ElementUtils.setTransform((IElement)e, (AffineTransform)at);
        double[] coordinates = DiagramGraphUtil.getPossibleRelatedDoubleArray(graph, element, G2D.HasPoint2DArray);
        if (coordinates != null) {
            int count = coordinates.length / 2;
            ArrayList<Point2D.Double> points = new ArrayList<Point2D.Double>(count);
            int i = 0;
            while (i < count) {
                points.add(new Point2D.Double(coordinates[i * 2], coordinates[i * 2 + 1]));
                ++i;
            }
            e.setHint(PathElementHandler.KEY_PATH_POINTS, points);
        }
        boolean closed = (Boolean)graph.getRelatedValue(element, G2D.IsClosedPath);
        e.setHint(PathElementHandler.KEY_PATH_CLOSED, (Object)closed);
        Resource color = graph.getSingleObject(element, G2D.HasColor);
        float[] colorF = (float[])graph.getValue(color, (Binding)Bindings.FLOAT_ARRAY);
        Resource fill = graph.getSingleObject(element, G2D.HasFillColor);
        float[] fillF = (float[])graph.getValue(fill, (Binding)Bindings.FLOAT_ARRAY);
        float strokeWidth = ((Float)graph.getRelatedValue(element, G2D.HasStrokeWidth)).floatValue();
        e.setHint(PathElementHandler.KEY_PATH_STYLE, (Object)new PathNodeStyle(colorF, fillF, strokeWidth));
        e.setHint(PathElementHandler.KEY_PATH_LISTENER, (Object)new IPathListener(){

            public void pathChanged(ArrayList<Point2D> points, final boolean closed) {
                int count = points.size();
                final double[] coordinates = new double[count * 2];
                int i = 0;
                for (Point2D point : points) {
                    coordinates[i++] = point.getX();
                    coordinates[i++] = point.getY();
                }
                Simantics.async((WriteInterface)new WriteRequest(){

                    public void perform(WriteGraph graph) throws DatabaseException {
                        graph.markUndoPoint();
                        graph.claimLiteral(element, G2D.HasPoint2DArray, (Object)coordinates);
                        graph.claimLiteral(element, G2D.IsClosedPath, (Object)closed);
                    }
                });
            }
        });
    }
}

