/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.diagram.adapter;

import java.util.List;
import org.simantics.db.AsyncReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.primitiverequest.Adapter;
import org.simantics.db.common.procedure.adapter.TransientCacheAsyncListener;
import org.simantics.db.procedure.AsyncListener;
import org.simantics.db.procedure.AsyncProcedure;
import org.simantics.db.procedure.Listener;
import org.simantics.db.request.AsyncRead;
import org.simantics.db.request.Read;
import org.simantics.diagram.adapter.BaseRequest2;
import org.simantics.diagram.adapter.ElementFactory;
import org.simantics.diagram.adapter.ElementFactoryUtil;
import org.simantics.diagram.adapter.GetElementClassRequest;
import org.simantics.diagram.adapter.LoadRequest;
import org.simantics.diagram.adapter.SpawnRequest;
import org.simantics.diagram.synchronization.ErrorHandler;
import org.simantics.g2d.canvas.ICanvasContext;
import org.simantics.g2d.diagram.IDiagram;
import org.simantics.g2d.diagram.handler.SubstituteElementClass;
import org.simantics.g2d.element.ElementClass;
import org.simantics.g2d.element.IElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeRequest
extends BaseRequest2<Resource, IElement> {
    private static final Logger LOGGER = LoggerFactory.getLogger(NodeRequest.class);
    final IDiagram diagram;
    final Listener<IElement> loadListener;
    static int loadCounter = 0;
    static int spawnCounter = 0;

    public NodeRequest(ICanvasContext canvas, IDiagram diagram, Resource resource, Listener<IElement> loadListener) {
        super(canvas, resource);
        this.diagram = diagram;
        this.loadListener = loadListener;
    }

    public void perform(AsyncReadGraph graph, final AsyncProcedure<IElement> procedure) {
        if (this.diagram == null) {
            procedure.exception(graph, (Throwable)new NullPointerException("null diagram specified for resource " + this.data));
            return;
        }
        final ErrorHandler eh = ElementFactoryUtil.getErrorHandler(this.diagram);
        graph.forHasStatement((Resource)this.data, (AsyncProcedure)new AsyncProcedure<Boolean>(){

            public void exception(AsyncReadGraph graph, Throwable throwable) {
                eh.error("NodeRequest.forHasStatement failed", throwable);
                procedure.execute(graph, null);
            }

            public void execute(AsyncReadGraph graph, Boolean result) {
                if (!result.booleanValue()) {
                    procedure.execute(graph, null);
                    return;
                }
                graph.asyncRequest((Read)new Adapter((Resource)NodeRequest.this.data, ElementFactory.class), (AsyncListener)new TransientCacheAsyncListener<ElementFactory>(){

                    public void exception(AsyncReadGraph graph, Throwable throwable) {
                        eh.error("NodeRequest.asyncRequest(Adapter<ElementFactory>) failed", throwable);
                        procedure.execute(graph, null);
                    }

                    public void execute(AsyncReadGraph graph, final ElementFactory factory) {
                        graph.asyncRequest((AsyncRead)new GetElementClassRequest(factory, (Resource)(this).NodeRequest.this.data, (this).NodeRequest.this.canvas, (this).NodeRequest.this.diagram), (AsyncListener)new TransientCacheAsyncListener<ElementClass>(){

                            public void exception(AsyncReadGraph graph, Throwable throwable) {
                                LOGGER.error("Unexpected error in GetElementClassRequest", throwable);
                                procedure.execute(graph, null);
                            }

                            public void execute(AsyncReadGraph graph, ElementClass mutableClazz) {
                                List substitutes = ((this).this).NodeRequest.this.diagram.getDiagramClass().getItemsByClass(SubstituteElementClass.class);
                                for (SubstituteElementClass subs : substitutes) {
                                    mutableClazz = subs.substitute(((this).this).NodeRequest.this.diagram, mutableClazz);
                                }
                                final ElementClass clazz = mutableClazz;
                                graph.asyncRequest((AsyncRead)new SpawnRequest(((this).this).NodeRequest.this.canvas, clazz, (Resource)((this).this).NodeRequest.this.data), (AsyncListener)new TransientCacheAsyncListener<IElement>(){

                                    public void exception(AsyncReadGraph graph, Throwable throwable) {
                                        LOGGER.error("Unexpected error in SpawnRequest", throwable);
                                        procedure.execute(graph, null);
                                    }

                                    public void execute(AsyncReadGraph graph, IElement element) {
                                        procedure.execute(graph, (Object)element);
                                        if ((((this).this).this).NodeRequest.this.loadListener != null) {
                                            graph.asyncRequest((AsyncRead)new LoadRequest((((this).this).this).NodeRequest.this.canvas, (((this).this).this).NodeRequest.this.diagram, factory, clazz, (Resource)(((this).this).this).NodeRequest.this.data), (((this).this).this).NodeRequest.this.loadListener);
                                        } else {
                                            factory.load(graph, (((this).this).this).NodeRequest.this.canvas, (((this).this).this).NodeRequest.this.diagram, (Resource)(((this).this).this).NodeRequest.this.data, element, new AsyncProcedure<IElement>(){

                                                public void exception(AsyncReadGraph graph, Throwable throwable) {
                                                    LOGGER.error("Unexpected error in ElementFactory.load (factory=" + factory + ")", throwable);
                                                }

                                                public void execute(AsyncReadGraph graph, IElement result) {
                                                }
                                            });
                                        }
                                    }
                                });
                            }
                        });
                    }
                });
            }
        });
    }
}

