/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.indexing;

import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.Semaphore;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Stream;
import org.apache.lucene.queryparser.classic.ParseException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.common.request.ReadRequest;
import org.simantics.db.common.request.UniqueRead;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.InvalidResourceReferenceException;
import org.simantics.db.exception.ServiceException;
import org.simantics.db.indexing.DatabaseIndexing;
import org.simantics.db.indexing.IndexPolicy;
import org.simantics.db.indexing.IndexedRelationsSearcher;
import org.simantics.db.indexing.IndexedRelationsSearcherBase;
import org.simantics.db.indexing.MemoryIndexing;
import org.simantics.db.indexing.exception.IndexingException;
import org.simantics.db.layer0.adapter.GenericRelation;
import org.simantics.db.layer0.genericrelation.IndexException;
import org.simantics.db.layer0.genericrelation.IndexedRelations;
import org.simantics.db.layer0.util.Layer0Utils;
import org.simantics.db.request.Read;
import org.simantics.db.request.ReadInterface;
import org.simantics.db.service.SerialisationSupport;
import org.simantics.operation.Layer0X;
import org.simantics.utils.datastructures.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexedRelationsImpl
implements IndexedRelations {
    private static final Logger LOGGER = LoggerFactory.getLogger(IndexedRelationsImpl.class);
    Map<Object, RWLock> indexLocks = new WeakHashMap<Object, RWLock>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LockHandle lock(RequestProcessor processor, Object lockIdentifier, boolean write) {
        RWLock rwlock = null;
        Map<Object, RWLock> map = this.indexLocks;
        synchronized (map) {
            rwlock = this.indexLocks.get(lockIdentifier);
            if (rwlock == null) {
                rwlock = new RWLock(lockIdentifier);
                this.indexLocks.put(lockIdentifier, rwlock);
            }
        }
        return rwlock.lock(processor, write);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LockHandle tryLock(RequestProcessor processor, Object lockIdentifier, boolean write) {
        RWLock rwlock = null;
        Map<Object, RWLock> map = this.indexLocks;
        synchronized (map) {
            rwlock = this.indexLocks.get(lockIdentifier);
            if (rwlock == null) {
                rwlock = new RWLock(lockIdentifier);
                this.indexLocks.put(lockIdentifier, rwlock);
            }
        }
        return rwlock.tryLock(processor, write);
    }

    private static IndexedRelationsSearcherBase makeSearcher(final RequestProcessor processor, final Resource relation, final Resource input) {
        try {
            return (IndexedRelationsSearcherBase)processor.syncRequest((Read)new UniqueRead<IndexedRelationsSearcherBase>(){

                public IndexedRelationsSearcherBase perform(ReadGraph graph) throws DatabaseException {
                    if (graph.isImmutable(input)) {
                        return MemoryIndexing.getInstance(processor.getSession()).getImmutable(processor, relation, input);
                    }
                    return MemoryIndexing.getInstance(processor.getSession()).get(processor, relation, input);
                }
            });
        }
        catch (DatabaseException e) {
            throw new IllegalStateException(e);
        }
    }

    private LockHandle waitLoaded(SubMonitor progress, final IndexedRelationsSearcherBase searcher, RequestProcessor processor, LockHandle lock, final Object lockId, final Resource input) throws IndexException {
        if (searcher.isIndexAvailable()) {
            searcher.startAccess((IProgressMonitor)progress.newChild(50), processor.getSession(), false);
            if (searcher.hasAccess(false)) {
                return lock;
            }
            if (searcher.checkState(IndexedRelationsSearcherBase.State.PROBLEM)) {
                throw new IndexException("Searcher is in problematic state", searcher.getException());
            }
        }
        searcher.assertState(IndexedRelationsSearcherBase.State.NONE);
        while (true) {
            if (processor instanceof ReadGraph) {
                try {
                    SerialisationSupport ss = (SerialisationSupport)processor.getService(SerialisationSupport.class);
                    searcher.initializeIndex((IProgressMonitor)progress.newChild(40), (ReadGraph)processor, new Object[]{ss.getRandomAccessId(input)}, true);
                    searcher.setReady();
                    searcher.startAccess((IProgressMonitor)progress.newChild(10), processor.getSession(), false);
                    if (!searcher.hasAccess(false)) continue;
                    return lock;
                }
                catch (IOException e) {
                    searcher.setProblem(e);
                    throw new IndexException((Throwable)e);
                }
                catch (DatabaseException e) {
                    searcher.setProblem(e);
                    throw new IndexException((Throwable)e);
                }
            }
            lock.unlock();
            boolean success = false;
            int tries = 0;
            while (!success && ++tries < 10) {
                try {
                    success = (Boolean)processor.sync((ReadInterface)new UniqueRead<Boolean>(){

                        public Boolean perform(ReadGraph graph) throws DatabaseException {
                            block10: {
                                LockHandle lock = IndexedRelationsImpl.this.tryLock((RequestProcessor)graph, lockId, true);
                                if (lock == null) {
                                    return false;
                                }
                                try {
                                    boolean loaded = false;
                                    if (searcher.isIndexAvailable()) {
                                        searcher.startAccess(null, graph.getSession(), false);
                                        if (searcher.hasAccess(false)) {
                                            loaded = true;
                                        }
                                        if (searcher.checkState(IndexedRelationsSearcherBase.State.PROBLEM)) {
                                            throw new IndexingException("Searcher is in problematic state", searcher.getException());
                                        }
                                    }
                                    if (loaded) break block10;
                                    if (!searcher.checkState(IndexedRelationsSearcherBase.State.NONE)) {
                                        throw new IndexingException("Illegal searcher state " + (Object)((Object)searcher.state()));
                                    }
                                    try {
                                        SerialisationSupport ss = (SerialisationSupport)graph.getService(SerialisationSupport.class);
                                        searcher.initializeIndex(null, graph, new Object[]{ss.getRandomAccessId(input)}, true);
                                        searcher.setReady();
                                    }
                                    catch (IOException e) {
                                        searcher.setProblem(e);
                                        throw new IndexingException(e);
                                    }
                                }
                                finally {
                                    lock.unlock();
                                }
                            }
                            return true;
                        }
                    });
                }
                catch (DatabaseException e) {
                    throw new IndexException((Throwable)e);
                }
            }
            if (!success) {
                throw new IndexException("Did not manage to load index.");
            }
            lock = this.lock(processor, lockId, true);
            if (searcher.isIndexAvailable()) break;
        }
        searcher.startAccess((IProgressMonitor)progress.newChild(50), processor.getSession(), false);
        if (searcher.hasAccess(false)) {
            return lock;
        }
        throw new IndexException("Illegal searcher state " + (Object)((Object)searcher.state()));
    }

    public List<Resource> queryResources(IProgressMonitor monitor, String search, RequestProcessor processor, Resource relation, Resource input, int maxResultCount) {
        if (processor == null) {
            throw new IllegalArgumentException("null processor");
        }
        if (relation == null) {
            throw new IllegalArgumentException("null relation");
        }
        if (input == null) {
            throw new IllegalArgumentException("null input");
        }
        if (search == null) {
            throw new IllegalArgumentException("null search criterion");
        }
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        IndexedRelationsSearcherBase searcher = IndexedRelationsImpl.makeSearcher(processor, relation, input);
        Pair lockId = Pair.make((Object)relation, (Object)input);
        LockHandle lock = this.lock(processor, lockId, false);
        lock = this.waitLoaded(progress, searcher, processor, lock, lockId, input);
        try {
            List<Resource> list = searcher.doSearchResources((IProgressMonitor)progress.newChild(50), processor, search, maxResultCount);
            return list;
        }
        catch (ParseException e) {
            e.printStackTrace();
            List<Resource> list = Collections.emptyList();
            return list;
        }
        catch (IOException e) {
            throw new IndexException((Throwable)e);
        }
        catch (DatabaseException e) {
            throw new IndexException((Throwable)e);
        }
        finally {
            lock.unlock();
        }
    }

    public List<Map<String, Object>> query(IProgressMonitor monitor, String search, RequestProcessor processor, Resource relation, Resource input, int maxResultCount) {
        if (processor == null) {
            throw new IllegalArgumentException("null processor");
        }
        if (relation == null) {
            throw new IllegalArgumentException("null relation");
        }
        if (input == null) {
            throw new IllegalArgumentException("null input");
        }
        if (search == null) {
            throw new IllegalArgumentException("null search criterion");
        }
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        IndexedRelationsSearcherBase searcher = IndexedRelationsImpl.makeSearcher(processor, relation, input);
        Pair lockId = Pair.make((Object)relation, (Object)input);
        LockHandle lock = this.lock(processor, lockId, false);
        lock = this.waitLoaded(progress, searcher, processor, lock, lockId, input);
        try {
            List<Map<String, Object>> list = searcher.doSearch((IProgressMonitor)progress.newChild(50), processor, search, maxResultCount);
            return list;
        }
        catch (ParseException e) {
            e.printStackTrace();
            List<Map<String, Object>> list = Collections.emptyList();
            return list;
        }
        catch (IOException e) {
            throw new IndexException((Throwable)e);
        }
        catch (DatabaseException e) {
            throw new IndexException((Throwable)e);
        }
        finally {
            lock.unlock();
        }
    }

    public void insert(IProgressMonitor monitor, RequestProcessor processor, GenericRelation relation, Resource relationResource, Resource input, Collection<Object[]> documents) throws IndexException {
        if (relation == null) {
            throw new IllegalArgumentException("null relation");
        }
        if (input == null) {
            throw new IllegalArgumentException("null input");
        }
        if (documents == null) {
            throw new IllegalArgumentException("null documents");
        }
        if (documents.isEmpty()) {
            return;
        }
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        IndexedRelationsSearcherBase searcher = IndexedRelationsImpl.makeSearcher(processor, relationResource, input);
        LockHandle handle = this.lock(processor, Pair.make((Object)relationResource, (Object)input), true);
        try {
            DatabaseIndexing.markIndexChanged(processor.getSession(), searcher.getIndexPath());
            if (!searcher.startAccess(null, processor.getSession(), true)) {
                return;
            }
            try {
                searcher.insertIndex((IProgressMonitor)progress.newChild(40), relation, 1, documents);
            }
            catch (InvalidResourceReferenceException e) {
                throw new IndexException((ServiceException)e);
            }
            catch (IOException e) {
                throw new IndexException((Throwable)e);
            }
            catch (DatabaseException e) {
                throw new IndexException((Throwable)e);
            }
        }
        finally {
            handle.unlock();
        }
    }

    public void remove(IProgressMonitor monitor, RequestProcessor processor, GenericRelation relation, Resource relationResource, Resource input, String key, Collection<Object> keyValues) throws IndexException {
        if (relation == null) {
            throw new IllegalArgumentException("null relation");
        }
        if (input == null) {
            throw new IllegalArgumentException("null input");
        }
        if (key == null) {
            throw new IllegalArgumentException("null key");
        }
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        IndexedRelationsSearcherBase searcher = IndexedRelationsImpl.makeSearcher(processor, relationResource, input);
        LockHandle handle = this.lock(processor, Pair.make((Object)relationResource, (Object)input), true);
        try {
            DatabaseIndexing.markIndexChanged(processor.getSession(), searcher.getIndexPath());
            if (!searcher.startAccess(null, processor.getSession(), true)) {
                return;
            }
            try {
                searcher.removeIndex((IProgressMonitor)progress.newChild(40), relation, processor, key, keyValues);
            }
            catch (DatabaseException e) {
                throw new IndexException((Throwable)e);
            }
            catch (IOException e) {
                throw new IndexException((Throwable)e);
            }
        }
        finally {
            handle.unlock();
        }
    }

    public void removeAll(IProgressMonitor monitor, RequestProcessor processor, GenericRelation relation, Resource relationResource, Resource input) {
        if (relation == null) {
            throw new IllegalArgumentException("null relation");
        }
        if (input == null) {
            throw new IllegalArgumentException("null input");
        }
        IndexedRelationsSearcherBase searcher = IndexedRelationsImpl.makeSearcher(processor, relationResource, input);
        LockHandle handle = this.lock(processor, Pair.make((Object)relationResource, (Object)input), true);
        try {
            Throwable t = searcher.bestEffortClear(monitor, processor.getSession());
            if (t != null) {
                searcher.setProblem(t);
            } else {
                searcher.setNone();
            }
        }
        finally {
            handle.unlock();
        }
    }

    public boolean replace(IProgressMonitor monitor, RequestProcessor processor, GenericRelation relation, Resource relationResource, Resource input, String key, Collection<Object> keyValues, Collection<Object[]> documents) throws IndexException {
        if (relation == null) {
            throw new IllegalArgumentException("null relation");
        }
        if (input == null) {
            throw new IllegalArgumentException("null input");
        }
        if (key == null) {
            throw new IllegalArgumentException("null key");
        }
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        IndexedRelationsSearcherBase searcher = IndexedRelationsImpl.makeSearcher(processor, relationResource, input);
        LockHandle handle = this.lock(processor, Pair.make((Object)relationResource, (Object)input), true);
        boolean didChange = false;
        try {
            DatabaseIndexing.markIndexChanged(processor.getSession(), searcher.getIndexPath());
            if (!searcher.startAccess(null, processor.getSession(), true)) {
                return true;
            }
            try {
            }
            catch (InvalidResourceReferenceException e) {
                throw new IndexException((ServiceException)e);
            }
            catch (IOException e) {
                throw new IndexException((Throwable)e);
            }
            catch (DatabaseException e) {
                throw new IndexException((Throwable)e);
            }
            catch (Throwable t) {
                throw new IndexException(t);
            }
        }
        finally {
            handle.unlock();
        }
        return didChange |= searcher.replaceIndex((IProgressMonitor)progress.newChild(40), key, keyValues, relation, 1, documents);
    }

    public void reset(IProgressMonitor monitor, RequestProcessor processor, Resource relationResource, Resource input) throws IndexException {
        IndexedRelationsSearcherBase searcher = IndexedRelationsImpl.makeSearcher(processor, relationResource, input);
        LockHandle handle = this.lock(processor, Pair.make((Object)relationResource, (Object)input), true);
        Path path = DatabaseIndexing.getIndexLocation(processor.getSession(), relationResource, input);
        try {
            try {
                searcher.changeState(monitor, processor.getSession(), IndexedRelationsSearcherBase.State.NONE);
                if (!searcher.checkState(IndexedRelationsSearcherBase.State.NONE)) {
                    throw new IndexException("Could not close index for input " + input + " before removing it");
                }
                DatabaseIndexing.deleteIndex(path);
            }
            catch (IOException e) {
                LOGGER.error("Could not delete index for {} from path {}", new Object[]{input, path.toAbsolutePath(), e});
                throw new IndexException((Throwable)e);
            }
        }
        finally {
            handle.unlock();
        }
    }

    public void fullRebuild(final IProgressMonitor monitor, RequestProcessor processor) throws IndexException {
        try {
            processor.syncRequest((Read)new ReadRequest(){

                public void run(ReadGraph graph) throws DatabaseException {
                    try {
                        IndexedRelationsImpl.this.fullRebuild(monitor, graph);
                    }
                    catch (IOException e) {
                        throw new IndexingException(e);
                    }
                }
            });
        }
        catch (DatabaseException e) {
            throw new IndexException((Throwable)e);
        }
    }

    private void fullRebuild(IProgressMonitor monitor, ReadGraph graph) throws DatabaseException, IOException {
        long startTime = System.currentTimeMillis();
        Resource relation = Layer0X.getInstance((ReadGraph)graph).DependenciesRelation;
        SerialisationSupport ss = (SerialisationSupport)graph.getService(SerialisationSupport.class);
        Set indexRoots = Layer0Utils.listIndexRoots((ReadGraph)graph);
        ArrayList waitFor = new ArrayList(indexRoots.size());
        SubMonitor mon = SubMonitor.convert((IProgressMonitor)monitor, (int)(indexRoots.size() * 2));
        for (Resource resource : indexRoots) {
            monitor.subTask(NameUtils.getSafeName((ReadGraph)graph, (Resource)resource));
            IndexedRelationsSearcherBase searcher = IndexedRelationsImpl.makeSearcher((RequestProcessor)graph, relation, resource);
            GenericRelation r = (GenericRelation)graph.adapt(relation, GenericRelation.class);
            if (r == null) {
                throw new IndexingException("Given resource " + relation + "could not be adapted to GenericRelation.");
            }
            Object[] bound = new Object[]{ss.getRandomAccessId(resource)};
            GenericRelation selection = r.select(IndexedRelationsSearcherBase.getPattern(r, bound.length), bound);
            long relStart = System.currentTimeMillis();
            List results = selection.realize(graph);
            if (LOGGER.isDebugEnabled()) {
                long relEnd = System.currentTimeMillis() - relStart;
                LOGGER.debug(resource + " realized " + relEnd);
            }
            mon.worked(1);
            CompletableFuture result = new CompletableFuture();
            waitFor.add(result);
            ForkJoinPool.commonPool().submit(() -> {
                long startTime1 = System.currentTimeMillis();
                try {
                    try {
                        searcher.initializeIndexImpl(result, (IProgressMonitor)mon.newChild(1, 7), r, results, bound, true);
                        searcher.setReady();
                    }
                    catch (IOException e) {
                        result.completeExceptionally(e);
                        LOGGER.error("Could not initialize index", (Throwable)e);
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug(indexRoot + " initialized " + (System.currentTimeMillis() - startTime1));
                        }
                    }
                }
                finally {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug(indexRoot + " initialized " + (System.currentTimeMillis() - startTime1));
                    }
                }
            });
        }
        for (CompletableFuture completableFuture : waitFor) {
            try {
                completableFuture.get();
            }
            catch (InterruptedException | ExecutionException e) {
                throw (IOException)e.getCause();
            }
        }
        if (LOGGER.isInfoEnabled()) {
            long l = System.currentTimeMillis() - startTime;
            LOGGER.info("All indexes rebuilt in {}", (Object)l);
        }
    }

    public void flush(IProgressMonitor progress, Session session) throws IndexException {
        long startTime = System.currentTimeMillis();
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress);
        MemoryIndexing mem = MemoryIndexing.getInstance(session);
        try {
            List<IndexedRelationsSearcherBase> searchers = mem.getAllSearchers();
            int count = searchers.size();
            Semaphore sema = new Semaphore(0);
            ((Stream)searchers.stream().parallel()).forEach(s -> {
                LockHandle handle = this.lock((RequestProcessor)session, Pair.make((Object)s.getRelation(), (Object)s.getInput()), true);
                try {
                    if (s.isIndexAvailable() && s instanceof IndexedRelationsSearcher) {
                        IndexedRelationsSearcher searcher = (IndexedRelationsSearcher)s;
                        try {
                            List<Object[]> os = searcher.cache.allDocs((IProgressMonitor)monitor, session);
                            searcher.applyChanges((IProgressMonitor)monitor, session, searcher.cache.r, os);
                        }
                        catch (Exception e) {
                            LOGGER.error("Could not flush in-memory changes to on-disk index", (Throwable)e);
                        }
                    }
                    monitor.worked(1);
                    s.changeState((IProgressMonitor)monitor, session, IndexedRelationsSearcherBase.State.READY);
                }
                finally {
                    handle.unlock();
                    sema.release();
                }
            });
            sema.acquire(count);
            long totalTime = System.currentTimeMillis() - startTime;
            LOGGER.info("Database index cache flush done in {} ms", (Object)totalTime);
        }
        catch (InterruptedException e) {
            LOGGER.error("Index searcher flush interrupted", (Throwable)e);
        }
    }

    static class LockHandle {
        public final Object id;
        public final Lock lock;

        public LockHandle(Object id, Lock lock) {
            this.id = id;
            this.lock = lock;
        }

        public void unlock() {
            if (IndexPolicy.TRACE_INDEX_LOCKING) {
                System.out.println("Unlocking index " + this.id);
            }
            this.lock.unlock();
        }
    }

    static class RWLock {
        public final Object id;
        public final ReentrantReadWriteLock lock;

        public RWLock(Object id) {
            this.id = id;
            this.lock = new ReentrantReadWriteLock(true);
        }

        LockHandle lock(RequestProcessor processor, boolean write) {
            Lock l;
            Lock lock = l = write ? this.lock.writeLock() : this.lock.readLock();
            if (processor instanceof ReadGraph) {
                ReadGraph cfr_ignored_0 = (ReadGraph)processor;
                while (!l.tryLock()) {
                    try {
                        Thread.sleep(1L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            } else {
                l.lock();
            }
            if (IndexPolicy.TRACE_INDEX_LOCKING) {
                System.out.println("Locked index " + this.id);
            }
            return new LockHandle(this.id, l);
        }

        LockHandle tryLock(RequestProcessor processor, boolean write) {
            Lock l;
            Lock lock = l = write ? this.lock.writeLock() : this.lock.readLock();
            if (l.tryLock()) {
                return new LockHandle(this.id, l);
            }
            return null;
        }
    }
}

