/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.project.features.registry;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.equinox.p2.metadata.IVersionedId;
import org.eclipse.equinox.p2.metadata.VersionedId;
import org.osgi.framework.Version;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.Files;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.serialization.SerializationException;
import org.simantics.graph.representation.TransferableGraph1;
import org.simantics.project.features.registry.GroupReference;
import org.simantics.project.management.GraphBundleEx;
import org.simantics.utils.strings.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class PluginParser {
    protected Logger log = Logger.getLogger(PluginParser.class.toString());
    protected List<GraphBundleEx> graphBundles = new ArrayList<GraphBundleEx>();
    protected Set<GroupReference> groupReferences = new TreeSet<GroupReference>();

    public static void main(String[] args) {
        PluginParser tester = new PluginParser();
        tester.parse("/home/jplaine/tmp/");
    }

    public List<GraphBundleEx> getGraphBundles() {
        return this.graphBundles;
    }

    public Set<GroupReference> getGroupReferences() {
        return this.groupReferences;
    }

    public void parse(String filename) {
        this.parse(new File(filename));
    }

    public void parse(File root) {
        if (root.isFile()) {
            this.parseJar(root.getAbsoluteFile().toString());
        } else if (root.isDirectory()) {
            File[] fileArray = root.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (file.isFile()) {
                    this.parseJar(file.getAbsoluteFile().toString());
                }
                ++n2;
            }
        }
    }

    public Collection<GroupReference> parsePluginXML(InputStream is) throws IOException {
        ArrayList<GroupReference> result = new ArrayList<GroupReference>();
        try {
            try {
                DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                DocumentBuilder db = dbf.newDocumentBuilder();
                Document doc = db.parse(is);
                doc.getDocumentElement().normalize();
                for (Element element : PluginParser.getElementsByTagName(doc.getDocumentElement(), "extension")) {
                    if (!"org.simantics.project.feature".equals(element.getAttribute("point"))) continue;
                    for (Element feature : PluginParser.getElementsByTagName(element, "feature")) {
                        for (Element installGroup : PluginParser.getElementsByTagName(feature, "installGroup")) {
                            String id = StringUtils.safeString((String)installGroup.getAttribute("id"));
                            if (id.isEmpty()) continue;
                            String version = StringUtils.safeString((String)installGroup.getAttribute("version"));
                            if (version.isEmpty()) {
                                version = null;
                            }
                            result.add(new GroupReference(id, version));
                        }
                    }
                }
            }
            catch (ParserConfigurationException e) {
                throw new IOException("Problem loading plugin.xml ", e);
            }
            catch (SAXException e) {
                throw new IOException("Problem loading plugin.xml ", e);
            }
        }
        finally {
            is.close();
        }
        return result;
    }

    public GraphBundleEx parseGraph(InputStream is, Manifest mf) throws IOException {
        String name = "";
        String symbolicName = "";
        VersionedId vid = null;
        if (mf != null) {
            Attributes attr = mf.getMainAttributes();
            String versionInfo = attr.getValue("Bundle-Version");
            symbolicName = attr.getValue("Bundle-SymbolicName");
            Version osgiVersion = new Version(versionInfo);
            org.eclipse.equinox.p2.metadata.Version p2Version = org.eclipse.equinox.p2.metadata.Version.createOSGi((int)osgiVersion.getMajor(), (int)osgiVersion.getMinor(), (int)osgiVersion.getMicro(), (String)osgiVersion.getQualifier());
            vid = new VersionedId(symbolicName, p2Version);
            name = attr.getValue("Bundle-Name");
            if (name == null) {
                name = symbolicName;
            }
        }
        GraphBundleEx bundleEntry = null;
        try {
            try {
                Binding binding = Bindings.getBindingUnchecked(TransferableGraph1.class);
                TransferableGraph1 graph = (TransferableGraph1)Files.readFile((InputStream)is, (Binding)binding);
                bundleEntry = new GraphBundleEx(name, graph, (IVersionedId)vid);
            }
            catch (SerializationException ex) {
                throw new IOException(ex);
            }
            catch (IOException ex) {
                throw new IOException("Problem loading graph.tg from bundle " + symbolicName, ex);
            }
            catch (RuntimeException ex) {
                throw new IOException("Problem loading graph.tg from bundle " + symbolicName, ex);
            }
        }
        finally {
            is.close();
        }
        return bundleEntry;
    }

    public void parseJar(String filename) {
        try {
            JarFile jar = new JarFile(filename);
            Enumeration<JarEntry> e = jar.entries();
            while (e.hasMoreElements()) {
                InputStream is;
                JarEntry entry = e.nextElement();
                if (entry.isDirectory()) continue;
                if ("plugin.xml".equals(entry.getName())) {
                    is = jar.getInputStream(entry);
                    Collection<GroupReference> groupReferences = this.parsePluginXML(is);
                    for (GroupReference ref : groupReferences) {
                        this.log.info("Found group reference: " + ref);
                    }
                    continue;
                }
                if (!"graph.tg".equals(entry.getName())) continue;
                is = jar.getInputStream(entry);
                Manifest mf = jar.getManifest();
                GraphBundleEx bundleEntry = this.parseGraph(is, mf);
                this.log.info("Found graph bundle: " + bundleEntry);
            }
            jar.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static Collection<Element> getElementsByTagName(Element parent, String name) {
        ArrayList<Element> elements = new ArrayList<Element>();
        NodeList nodeLst = parent.getElementsByTagName(name);
        int s = 0;
        while (s < nodeLst.getLength()) {
            if (nodeLst.item(s).getNodeType() == 1) {
                elements.add((Element)nodeLst.item(s));
            }
            ++s;
        }
        return elements;
    }
}

