/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.ui.actions.e4;

import javax.inject.Named;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.internal.e4.compatibility.CompatibilityEditor;
import org.simantics.db.Resource;
import org.simantics.modeling.ui.diagram.PageSettingsDialog;
import org.simantics.modeling.ui.diagramEditor.DiagramEditor;
import org.simantics.ui.workbench.IResourceEditorInput;
import org.simantics.utils.ui.workbench.WorkbenchUtils;

public class PageSettingsHandler {
    @CanExecute
    public boolean canExecute(@Named(value="e4ActivePart") @Named(value="e4ActivePart") MPart mActiveEditor) {
        DiagramEditor editor;
        IResourceEditorInput input;
        Resource diagramResource;
        IEditorPart activeEditor = null;
        if (mActiveEditor != null && mActiveEditor.getObject() instanceof CompatibilityEditor) {
            CompatibilityEditor compatEditor = (CompatibilityEditor)mActiveEditor.getObject();
            activeEditor = compatEditor.getEditor();
        }
        if (activeEditor == null) {
            return false;
        }
        return activeEditor instanceof DiagramEditor && (diagramResource = (input = (IResourceEditorInput)(editor = (DiagramEditor)activeEditor).getEditorInput()).getResource()) != null;
    }

    @Execute
    public void execute() {
        IEditorPart ap = WorkbenchUtils.getActiveEditor();
        if (ap instanceof DiagramEditor) {
            DiagramEditor editor = (DiagramEditor)ap;
            IResourceEditorInput input = (IResourceEditorInput)editor.getEditorInput();
            Resource diagramResource = input.getResource();
            if (diagramResource == null) {
                return;
            }
            PageSettingsDialog dialog = new PageSettingsDialog(diagramResource, ap.getSite().getShell());
            if (dialog.open() == 0) {
                dialog.applySettings();
            }
        }
    }
}

