package org.simantics.simulation.ui.handlers.e4;

import java.text.ParseException;

import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.osgi.util.NLS;
import org.simantics.simulation.experiment.SimulationTimeUtil;

/**
 * @author Tuukka Lehtonen
 * @since 1.39.0
 */
class TimeValidator implements IInputValidator {

    public String isValid(String s) {
        try {
            SimulationTimeUtil.getTimeFormat().parseObject(s);
            return null;
        } catch (ParseException e) {
            return NLS.bind("\"{0}\" is not a valid timestamp.", s);
        }
    }

}