package org.simantics.scl.osgi.internal;

import java.util.Collection;

import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;
import org.simantics.scl.compiler.testing.TestRunnable;
import org.simantics.scl.compiler.testing.repository.TestRepository;

public class ServiceBasedTestRepository implements TestRepository {

    ServiceTracker<TestRepository, TestRepository> repositories;

    public ServiceBasedTestRepository(BundleContext context) {
        repositories = new ServiceTracker<TestRepository, TestRepository>(
                context, TestRepository.class, null);
        repositories.open();
    }

    @Override
    public void collectTests(Collection<TestRunnable> tests) {
        Object[] services = repositories.getServices();
        if(services != null)
            for(Object repository : services)
                ((TestRepository)repository).collectTests(tests);
    }
    
}
