package org.simantics.scl.compiler.markdown.nodes;

import org.simantics.scl.compiler.markdown.html.HtmlGenerationContext;
import org.simantics.scl.compiler.markdown.internal.HtmlEscape;

public class CodeNode extends Node {
    public CodeNode(StringBuilder stringContent) {
        this.stringContent = stringContent;
    }
    
    @Override
    public void toHtml(HtmlGenerationContext context, StringBuilder b) {
        b.append("<code>");
        b.append(HtmlEscape.escape(stringContent));
        b.append("</code>");
    }
}
