package org.simantics.scl.compiler.internal.parsing.types;

import org.simantics.scl.compiler.elaboration.contexts.TypeTranslationContext;
import org.simantics.scl.compiler.internal.types.TypeElaborationContext;
import org.simantics.scl.compiler.types.TVar;
import org.simantics.scl.compiler.types.Type;
import org.simantics.scl.compiler.types.Types;
import org.simantics.scl.compiler.types.kinds.Kind;
import org.simantics.scl.compiler.types.kinds.Kinds;

import gnu.trove.map.hash.TObjectIntHashMap;
import gnu.trove.set.hash.TIntHashSet;



public class TForAllAst extends TypeAst {
    public final String[] vars;
    public final TypeAst type;
    
    public TForAllAst(String[] vars, TypeAst type) {
        this.vars = vars;
        this.type = type;
    }
    
    @Override
    public void toString(StringBuilder b) {
        b.append("forall");
        for(String var : vars) {
            b.append(' ');
            b.append(var);
        }
        b.append(". ");
        type.toString(b);
    }

    @Override
    public Type toType(TypeTranslationContext context, Kind expectedKind) {
        context.unify(location, Kinds.STAR, expectedKind);
        TVar[] oldVars = new TVar[vars.length];
        for(int i=0;i<vars.length;++i)
            oldVars[i] = context.pushTypeVar(vars[i]);
        Type result = type.toType(context, Kinds.STAR);
        for(int i=vars.length-1;i>=0;--i)
            result = Types.forAll(context.popTypeVar(vars[i], oldVars[i]), result);
        return result;
    }
    
    @Override
    public Type toType(TypeElaborationContext context) {
        TVar[] oldVars = new TVar[vars.length];
        for(int i=0;i<vars.length;++i)
            oldVars[i] = context.push(vars[i]);
        Type result = type.toType(context);
        for(int i=vars.length-1;i>=0;--i)
            result = Types.forAll(context.pop(vars[i], oldVars[i]), result);
        return result;
    }
    
    @Override
    public int getPrecedence() {
        return 2;
    }

    @Override
    public void collectReferences(TObjectIntHashMap<String> typeNameMap,
            TIntHashSet set) {
        type.collectReferences(typeNameMap, set);
    }
}
