package org.simantics.scl.compiler.errors;


@SuppressWarnings("rawtypes")
public enum DoesNotExist implements Failable {
    INSTANCE;

    @SuppressWarnings("unchecked")
    public static <T> Failable<T> getInstance() {
        return INSTANCE;
    }

    @Override
    public Object getResult() {
        throw new IllegalStateException("Module does not exist.");
    }

    @Override
    public boolean didSucceed() {
        return false;
    }
    
    @Override
    public String toString() {
        return "DoesNotExist";
    }

    @Override
    public String getDescription() {
        return "Module does not exist.";
    }
}
