package org.simantics.scl.compiler.environment;

import org.simantics.scl.compiler.elaboration.expressions.ESimpleLambda;
import org.simantics.scl.compiler.elaboration.expressions.Expression;
import org.simantics.scl.compiler.elaboration.expressions.Variable;
import org.simantics.scl.compiler.types.Type;
import org.simantics.scl.compiler.types.util.ProcedureType;

import gnu.trove.procedure.TObjectProcedure;

public abstract class AbstractLocalEnvironment implements LocalEnvironment {

    @Override
    public void forNames(TObjectProcedure<String> proc) {
    }

    protected Variable[] getContextVariables() {
        return Variable.EMPTY_ARRAY;
    }
    
    @Override
    public Expression preDecorateExpression(Expression expression) {
        return expression;
    }
    
    @Override
    public Expression postDecorateExpression(Expression expression) {
        Variable[] contextVariables = getContextVariables();
        for(int i=contextVariables.length-1;i>=0;--i)
            expression = new ESimpleLambda(contextVariables[i], expression);
        return expression;
    }

    @Override
    public ProcedureType decorateExpectedType(Type expectedType, Type expectedEffect) {
        /*Variable[] contextVariables = getContextVariables();
        for(int i=contextVariables.length-1;i>=0;--i) {
            expectedType = Types.functionE(contextVariables[i].getType(), expectedEffect, expectedType);
            expectedEffect = Types.NO_EFFECTS;
        }*/
        return new ProcedureType(expectedType, expectedEffect);
    }

}
