package org.simantics.scl.compiler.elaboration.relations;



import org.simantics.scl.compiler.elaboration.contexts.TranslationContext;
import org.simantics.scl.compiler.elaboration.expressions.Variable;
import org.simantics.scl.compiler.elaboration.query.Query;

public interface SCLEntityType {
    interface Attribute {
    }
    
    class AttributeBinding {
        public static final AttributeBinding[] EMPTY_ARRAY = new AttributeBinding[0];
        
        public Attribute attribute;
        public Variable variable;
        
        public AttributeBinding(Attribute attribute, Variable variable) {
            this.attribute = attribute;
            this.variable = variable;
        }
    }
    
    Query generateQuery(TranslationContext context, Variable base, AttributeBinding[] attributeBindings);
    Attribute getAttribute(String name);
}
