package org.simantics.scl.compiler.elaboration.java;

import org.cojen.classfile.TypeDesc;
import org.osgi.service.component.annotations.Component;
import org.simantics.scl.compiler.common.names.Name;
import org.simantics.scl.compiler.elaboration.contexts.SimplificationContext;
import org.simantics.scl.compiler.elaboration.expressions.EApply;
import org.simantics.scl.compiler.elaboration.expressions.EExternalConstant;
import org.simantics.scl.compiler.elaboration.expressions.Expression;
import org.simantics.scl.compiler.elaboration.macros.MacroRule;
import org.simantics.scl.compiler.elaboration.modules.SCLValue;
import org.simantics.scl.compiler.internal.codegen.types.StandardTypeConstructor;
import org.simantics.scl.compiler.module.ConcreteModule;
import org.simantics.scl.compiler.module.repository.ModuleRepository;
import org.simantics.scl.compiler.types.TCon;
import org.simantics.scl.compiler.types.Type;
import org.simantics.scl.compiler.types.Types;
import org.simantics.scl.compiler.types.kinds.Kinds;

public class CurrentModuleRepositoryModule extends ConcreteModule {
    
    public static CurrentModuleRepositoryModule INSTANCE = new CurrentModuleRepositoryModule();

    public CurrentModuleRepositoryModule() {
        super("SCL/CurrentModuleRepository");
        
        // ModuleRepository type
        TCon ModuleRepository = Types.con(getName(), "ModuleRepository");
        StandardTypeConstructor markerConstructor = new StandardTypeConstructor(ModuleRepository,
                Kinds.STAR, TypeDesc.forClass(ModuleRepository.class));
        markerConstructor.external = true;
        addTypeDescriptor("ModuleRepository", markerConstructor);
        
        // MODULE_REPOSITORY value
        SCLValue value = new SCLValue(Name.create(getName(), "MODULE_REPOSITORY"));
        value.setType(Types.functionE(Types.PUNIT, Types.NO_EFFECTS, ModuleRepository));
        value.setMacroRule(new MacroRule() {
            @Override
            public Expression apply(SimplificationContext context, Type[] typeParameters, EApply apply) {
                if(apply.parameters.length != 1)
                    return null;
                return new EExternalConstant(context.getCompilationContext().moduleRepository, ModuleRepository);
            }
        });
        addValue(value);
        
        setParentClassLoader(getClass().getClassLoader());
    }

}
