package org.simantics.scl.compiler.common.exceptions;

import org.simantics.scl.compiler.errors.Locations;

public class InternalCompilerError extends RuntimeException {

    private static final long serialVersionUID = -912160242899559098L;
    public long location;
    
    public InternalCompilerError() {
        super();
        this.location = Locations.NO_LOCATION;
    }
    
    public InternalCompilerError(long location) {
        super();
        this.location = location;
    }

    public InternalCompilerError(String message) {
        super(message);
        this.location = Locations.NO_LOCATION;
    }
    
    public InternalCompilerError(String message, Throwable cause) {
        super(message, cause);
        this.location = Locations.NO_LOCATION;
    }
    
    public InternalCompilerError(long location, String message) {
        super(message);
        this.location = location;
    }

    public InternalCompilerError(Throwable cause) {
        super(cause);
        this.location = Locations.NO_LOCATION;
    }
    
    public InternalCompilerError(long location, Throwable cause) {
        super(cause);
        this.location = location;
    }
    
    public static InternalCompilerError injectLocation(long location, Throwable cause) {
        if(cause instanceof InternalCompilerError) {
            InternalCompilerError e = (InternalCompilerError)cause;
            if(e.location == Locations.NO_LOCATION)
                e.location = location;
            return e;
        }
        else
            return new InternalCompilerError(location, cause);
    }
   
}
