/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.modeling.ui.modelBrowser.model;

import java.util.Collection;
import java.util.Collections;

import org.eclipse.jface.resource.ImageDescriptor;
import org.simantics.browsing.ui.common.node.IDeletable;
import org.simantics.browsing.ui.common.node.IModifiable;
import org.simantics.browsing.ui.content.Labeler.Modifier;
import org.simantics.browsing.ui.graph.impl.LabelModifier;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.modeling.ui.Activator;

@Deprecated
public class State extends Node implements IModifiable, IDeletable {

    public State(Resource resource) {
        super(resource);
    }

    @Override
    public Collection<?> getChildren(ReadGraph g) {
        return Collections.emptyList();
    }

    @Override
    public ImageDescriptor getImage(ReadGraph g) {
        return Activator.STATE_ICON;
    }

    @Override
    public Modifier getModifier(final Session session, String columnId) {
        return new LabelModifier(session, resource);
    }

    @Override
    public void handleDelete(WriteGraph graph) throws DatabaseException {
        // Must remove:
        //   1. the state itself
        //   2. all references to it state as an initial state from experiments

        // Handles both 1. and 2.
        super.handleDelete(graph);
    }

}
