/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.modeling.ui.modelBrowser.handlers;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.handlers.HandlerUtil;
import org.simantics.browsing.ui.GraphExplorer;
import org.simantics.browsing.ui.NodeContext;
import org.simantics.browsing.ui.common.ColumnKeys;
import org.simantics.utils.ui.ISelectionUtils;
import org.simantics.utils.ui.workbench.WorkbenchUtils;

public class RenameNodeHandler extends AbstractHandler {

    @Override
    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection sel = HandlerUtil.getCurrentSelection(event);
        NodeContext ctx = ISelectionUtils.filterSingleSelection(sel, NodeContext.class);
        if (ctx == null)
            return null;

        IWorkbenchPart part = HandlerUtil.getActivePart(event);
        if (part == null)
            return null;

        IActionBars bars = WorkbenchUtils.getActionBars(part);
        IStatusLineManager status = bars.getStatusLineManager();

        GraphExplorer graphExplorer = (GraphExplorer) part.getAdapter(GraphExplorer.class);
        if (graphExplorer != null) {
        	String error = graphExplorer.startEditing(ctx, ColumnKeys.SINGLE); 
            if (error != null) {
                status.setErrorMessage(error);
            } else {
                status.setErrorMessage(null);
            }
        }

        return null;
    }


}
