package org.simantics.modeling.ui.diagram.monitor;

import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.resource.ColorDescriptor;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchSite;
import org.simantics.browsing.ui.swt.widgets.DefaultColorProvider;
import org.simantics.browsing.ui.swt.widgets.TrackedText;
import org.simantics.browsing.ui.swt.widgets.impl.WidgetSupport;
import org.simantics.db.management.ISessionContext;
import org.simantics.selectionview.ConfigurationComposite;

public class MonitorExpressionComposite extends ConfigurationComposite {
    
    public void create(final Composite body, IWorkbenchSite site, final ISessionContext context, final WidgetSupport support) {
        
        final Display display = body.getDisplay();
        
        body.setBackground(display.getSystemColor(SWT.COLOR_WHITE));
        
//        Composite headerComposite = new Composite(body, 0);
//        headerComposite.setBackground(display.getSystemColor(SWT.COLOR_BLACK));
//        GridDataFactory.fillDefaults().span(2, 1).grab(true, false).applyTo(headerComposite);
//        GridLayoutFactory.fillDefaults().equalWidth(false).numColumns(1).extendedMargins(2,2,2,2).applyTo(headerComposite);
//
//        final Composite headerComposite2 = new Composite(headerComposite, 0);
//        headerComposite2.setBackground(display.getSystemColor(SWT.COLOR_WHITE));
//        GridDataFactory.fillDefaults().span(2, 1).grab(true, false).applyTo(headerComposite2);
//        GridLayoutFactory.fillDefaults().equalWidth(false).numColumns(2).extendedMargins(3,3,3,3).applyTo(headerComposite2);
//
//        final Label header = new Label(headerComposite2, support, 0);
//        header.setText("Monitor");
//        header.setFont(font);
//        header.setBackground(display.getSystemColor(SWT.COLOR_WHITE));
//        GridDataFactory.fillDefaults().grab(true, false).span(2, 1).align(SWT.CENTER, SWT.CENTER).applyTo(header.getWidget());
        
//        Composite buttonComposite = new Composite(body, SWT.NONE);
//        buttonComposite.setBackground(display.getSystemColor(SWT.COLOR_WHITE));
//        GridDataFactory.fillDefaults().span(2, 1).grab(true, false).applyTo(buttonComposite);
//        GridLayoutFactory.fillDefaults().equalWidth(false).numColumns(3).extendedMargins(5,5,5,5).applyTo(buttonComposite);
//
//        Label templateHeader = new Label(buttonComposite, support, 0);
//        templateHeader.setText("Template");
//        templateHeader.setFont(smallFont);
//        templateHeader.setBackground(display.getSystemColor(SWT.COLOR_WHITE));
//        GridDataFactory.fillDefaults().grab(false, false).span(1, 1).align(SWT.LEFT, SWT.CENTER).applyTo(templateHeader.getWidget());
//
//        Combo templateCombo = new Combo(buttonComposite, support, SWT.NONE | SWT.READ_ONLY);
//        templateCombo.setItemFactory(new AvailableTemplateFactory());
//        templateCombo.setSelectionFactory(new CurrentTemplateFactory());
//        templateCombo.addModifyListener(new TemplateModifier());
//        GridDataFactory.fillDefaults().grab(true, false).applyTo(templateCombo.getWidget());
//
//        Button resetButton = new Button(buttonComposite, support, SWT.NONE | SWT.READ_ONLY);
//        resetButton.setText("Reset Local Changes");
//        resetButton.addSelectionListener(new SelectionListenerImpl<Resource>(context) {
//
//			@Override
//			public void apply(WriteGraph graph, Resource monitor) throws DatabaseException {
//				
//				Layer0 L0 = Layer0.getInstance(graph);
//				DiagramResource DIA = DiagramResource.getInstance(graph);
//				if(graph.hasStatement(monitor, DIA.HasFont)) graph.deny(monitor, DIA.HasFont);
//				if(graph.hasStatement(monitor, DIA.HasFormatter)) graph.deny(monitor, DIA.HasFormatter);
//				if(graph.hasStatement(monitor, DIA.HasColor)) graph.deny(monitor, DIA.HasColor);
//				if(graph.hasStatement(monitor, L0X.HasExpression)) graph.deny(monitor, L0X.HasExpression);
//				
//			}
//			
//		});
//
//        GridDataFactory.fillDefaults().grab(false, false).applyTo(resetButton.getWidget());
//
//        Label fontHeader = new Label(buttonComposite, support, 0);
//        fontHeader.setText("Font Family");
//        fontHeader.setFont(smallFont);
//        fontHeader.setBackground(display.getSystemColor(SWT.COLOR_WHITE));
//        GridDataFactory.fillDefaults().grab(false, false).span(1, 1).align(SWT.LEFT, SWT.CENTER).applyTo(fontHeader.getWidget());
//
//        Combo fontCombo = new Combo(buttonComposite, support, SWT.NONE | SWT.READ_ONLY);
//      	fontCombo.setItemFactory2(new AvailableFontFactory());
//      	fontCombo.setSelectionFactory(new CurrentFontFactory());
//      	fontCombo.addModifyListener(new FontModifier());
//        GridDataFactory.fillDefaults().grab(true, false).span(2,1).applyTo(fontCombo.getWidget());
//
//        Label sizeHeader = new Label(buttonComposite, support, 0);
//        sizeHeader.setText("Font Size");
//        sizeHeader.setFont(smallFont);
//        sizeHeader.setBackground(display.getSystemColor(SWT.COLOR_WHITE));
//        GridDataFactory.fillDefaults().grab(false, false).span(1, 1).align(SWT.LEFT, SWT.CENTER).applyTo(sizeHeader.getWidget());
//
//        Combo sizeCombo = new Combo(buttonComposite, support, SWT.NONE | SWT.READ_ONLY);
//      	sizeCombo.setItemFactory2(new AvailableFontSizeFactory());
//      	sizeCombo.setSelectionFactory(new CurrentFontSizeFactory());
//      	sizeCombo.addModifyListener(new FontSizeModifier());
//        GridDataFactory.fillDefaults().grab(false, false).span(2,1).minSize(50, 0).applyTo(sizeCombo.getWidget());
//
//        Label formatterHeader = new Label(buttonComposite, support, 0);
//        formatterHeader.setText("Formatting");
//        formatterHeader.setFont(smallFont);
//        formatterHeader.setBackground(display.getSystemColor(SWT.COLOR_WHITE));
//        GridDataFactory.fillDefaults().grab(false, false).span(1, 1).align(SWT.LEFT, SWT.CENTER).applyTo(formatterHeader.getWidget());
//        
//        Combo formatCombo = new Combo(buttonComposite, support, SWT.NONE | SWT.READ_ONLY);
//      	formatCombo.setItemFactory(new AvailableFormatFactory());
//      	formatCombo.setSelectionFactory(new CurrentFormatFactory());
//      	formatCombo.addModifyListener(new FormatModifier());
//        GridDataFactory.fillDefaults().grab(true, false).span(2,1).applyTo(formatCombo.getWidget());
//        
//        Label expressionHeader = new Label(body, support, 0);
//        expressionHeader.setText("Expression");
//        expressionHeader.setFont(font);
//        expressionHeader.setBackground(display.getSystemColor(SWT.COLOR_WHITE));
//        GridDataFactory.fillDefaults().grab(true, false).span(2, 1).align(SWT.CENTER, SWT.CENTER).applyTo(expressionHeader.getWidget());

        TrackedText expression = new TrackedText(body, support, SWT.MULTI | SWT.BORDER);
        expression.setColorProvider(new DefaultColorProvider(expression.getResourceManager()) {
        	
            private final ColorDescriptor inactiveColor = ColorDescriptor.createFrom(new RGB(220, 220, 255));
        	
        	@Override
        	public Color getInactiveBackground() {
        		return resourceManager.createColor(inactiveColor);
        	}
        	
        });
        expression.setTextFactory(new CurrentExpressionFactory());
        expression.addModifyListener(new ExpressionModifier());
        GridDataFactory.fillDefaults().grab(true, true).applyTo(expression.getWidget());
        
    }
    
}
