package org.simantics.modeling.ui.actions;

import org.simantics.Simantics;
import org.simantics.browsing.ui.BuiltinKeys;
import org.simantics.browsing.ui.NodeContext;
import org.simantics.db.Resource;
import org.simantics.db.common.primitiverequest.Adapter;
import org.simantics.db.common.utils.Logger;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.ActionFactory;
import org.simantics.db.layer0.adapter.PasteHandler;
import org.simantics.modeling.ui.modelBrowser.handlers.StandardPasteHandler;

public class Paste implements ActionFactory {

	@Override
    public Runnable create(Object target) {

		if (!(target instanceof Resource))
			return null;
		
		final Resource resource = (Resource)target;
		
        return new Runnable() {
            @Override
            public void run() {

            	try {
            		PasteHandler handler = Simantics.getSession().syncRequest(new Adapter<PasteHandler>(resource, PasteHandler.class));
            		if (handler != null) {
            		    Simantics.getSession().markUndoPoint();
            			StandardPasteHandler.pasteResourceFromClipboardWithoutMonitor(handler);
            		}
            	} catch (DatabaseException e) {
            		Logger.defaultLogError(e);
            	}
            	
            }
        };
    }

}
