 
package org.simantics.logging.ui.handlers;

import java.util.List;
import java.util.function.Consumer;

import javax.inject.Named;

import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.services.IServiceConstants;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.widgets.Shell;
import org.simantics.logging.LogConfigurator;
import org.simantics.logging.LoggerLevel;
import org.simantics.logging.ui.LoggerManagementDialog;

/**
 * @author Tuukka Lehtonen
 * @since 1.47.0
 */
public class ConfigureLoggingHandler {

	@Execute
	public void execute(@Named(IServiceConstants.ACTIVE_SHELL) Shell shell) {
		Consumer<List<LoggerLevel>> applyConfiguration = LogConfigurator::applyLogLevels;

		LoggerManagementDialog dialog = new LoggerManagementDialog(shell, applyConfiguration);
		if (dialog.open() == Window.OK) {
			applyConfiguration.accept(dialog.getConfiguration());
		}
	}

}