/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.editors;

import java.io.File;
import java.net.URL;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;
import org.simantics.editors.internal.SystemFile;
import org.simantics.utils.ui.workbench.WorkbenchUtils;

public class Editors {

    public static IEditorPart openBrowser(URL url) throws PartInitException {
        return openBrowser(url, false);
    }

    public static IEditorPart openBrowser(URL url, boolean fullscreen) throws PartInitException {
        BrowserInput input = new BrowserInput(url, true, fullscreen);
        return WorkbenchUtils.openEditor("org.simantics.editors.browser", input);
    }
    
    public static IEditorPart openExternalEditor(File file) throws PartInitException {
		IEditorDescriptor desc = PlatformUI.getWorkbench().getEditorRegistry().findEditor(IEditorRegistry.SYSTEM_EXTERNAL_EDITOR_ID);
		IWorkspace ws = (IWorkspace) ResourcesPlugin.getWorkspace();
		FileEditorInput input = new ExternalFileEditorInput(new SystemFile(file, ws));
		IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
		IWorkbenchPage page = window.getActivePage();
		return page.openEditor(input, desc.getId());
		
	}
    
    private static class ExternalFileEditorInput extends FileEditorInput {

		public ExternalFileEditorInput(IFile file) {
			super(file);
		}
		
		@Override
		public void saveState(IMemento memento) {
			
		}
		
	}

}
