/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.debug.ui;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import org.simantics.Simantics;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.exception.DatabaseException;
import org.simantics.debug.ui.GraphDebugger;
import org.simantics.debug.ui.Messages;
import org.simantics.debug.ui.internal.Activator;
import org.simantics.debug.ui.internal.DebugUtils;
import org.simantics.ui.workbench.ResourceInput;
import org.simantics.utils.ui.BundleUtils;
import org.simantics.utils.ui.ErrorLogger;
import org.simantics.utils.ui.LayoutUtils;

public class GraphDebuggerView
extends ViewPart {
    public static final String VIEW_ID = "org.simantics.debug.graphDebugger";
    private ResourceInput input;
    private Session session;
    private GraphDebugger debugger;
    private IAction backAction;
    private IAction forwardAction;
    private IAction refreshAction;
    private IAction findAction;
    private IAction addStatementAction;
    private IAction addResourceAction;
    private IAction homeAction;

    public void createPartControl(Composite parent) {
        this.session = Simantics.getSession();
        String sid = this.getViewSite().getSecondaryId();
        Resource r = null;
        if (sid != null) {
            this.input = ResourceInput.unmarshall((String)sid);
            try {
                r = this.input.toResource(this.session);
            }
            catch (DatabaseException e) {
                ErrorLogger.defaultLogError((Throwable)e);
            }
        }
        parent.setLayout((Layout)LayoutUtils.createNoBorderGridLayout((int)1));
        this.debugger = new GraphDebugger(parent, 0, this.session, r, (IWorkbenchSite)this.getSite());
        this.debugger.defaultInitializeUI();
        this.makeActions();
        this.contributeActions(this.getViewSite().getActionBars());
        this.updateActionStates();
    }

    public void dispose() {
        super.dispose();
    }

    private void makeActions() {
        this.backAction = new BackAction();
        this.forwardAction = new ForwardAction();
        this.refreshAction = new RefreshAction();
        this.findAction = new FindAction();
        this.addStatementAction = new AddStatementAction();
        this.addResourceAction = new AddResourceAction();
        this.homeAction = new HomeAction();
    }

    private void contributeActions(IActionBars actionBars) {
        IToolBarManager toolBar = actionBars.getToolBarManager();
        toolBar.add(this.backAction);
        toolBar.add(this.forwardAction);
        toolBar.add((IContributionItem)new Separator());
        toolBar.add(this.refreshAction);
        toolBar.add((IContributionItem)new Separator());
        toolBar.add(this.findAction);
        toolBar.add(this.addStatementAction);
        toolBar.add(this.addResourceAction);
        toolBar.add((IContributionItem)new Separator());
        toolBar.add(this.homeAction);
    }

    public void setFocus() {
        if (this.debugger != null) {
            this.debugger.setFocus();
        }
    }

    private void refreshBrowser() {
        this.debugger.refreshBrowser();
    }

    private void back() {
        this.debugger.back();
    }

    private void forward() {
        this.debugger.forward();
    }

    private void navigateHome() {
        Resource rootLibrary = this.session.getRootLibrary();
        this.debugger.changeLocation(rootLibrary);
    }

    private void updateActionStates() {
        this.backAction.setEnabled(this.debugger.hasBackHistory());
        this.forwardAction.setEnabled(this.debugger.hasForwardHistory());
    }

    class AddResourceAction
    extends Action {
        public AddResourceAction() {
            super(Messages.GraphDebuggerView_AddResource, BundleUtils.getImageDescriptorFromPlugin((String)"org.simantics.debug.ui", (String)"icons/cog_add.png"));
            this.setToolTipText(Messages.GraphDebuggerView_AddResourceTT);
        }

        public void run() {
            try {
                DebugUtils.addResource(Simantics.getSession(), GraphDebuggerView.this.debugger);
            }
            catch (DatabaseException e) {
                Activator.getDefault().getLog().log((IStatus)new Status(4, "org.simantics.debug.ui", e.getMessage(), (Throwable)e));
            }
        }
    }

    class AddStatementAction
    extends Action {
        public AddStatementAction() {
            super(Messages.GraphDebuggerView_AddStatement, BundleUtils.getImageDescriptorFromPlugin((String)"org.simantics.debug.ui", (String)"icons/cog_add.png"));
            this.setToolTipText(Messages.GraphDebuggerView_AddStatementTT);
        }

        public void run() {
            try {
                DebugUtils.addStatement(Simantics.getSession(), GraphDebuggerView.this.debugger);
            }
            catch (DatabaseException e) {
                Activator.getDefault().getLog().log((IStatus)new Status(4, "org.simantics.debug.ui", e.getMessage(), (Throwable)e));
            }
        }
    }

    class BackAction
    extends Action {
        public BackAction() {
            super(Messages.GraphDebuggerView_Back, 1);
            this.setToolTipText(Messages.GraphDebuggerView_BackTT);
            this.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_BACK"));
            this.setDisabledImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_BACK_DISABLED"));
        }

        public void run() {
            GraphDebuggerView.this.back();
        }
    }

    class FindAction
    extends Action {
        public FindAction() {
            super(Messages.GraphDebuggerView_Find, BundleUtils.getImageDescriptorFromPlugin((String)"org.simantics.debug.ui", (String)"icons/cog_blue.png"));
            this.setToolTipText(Messages.GraphDebuggerView_FindTT);
        }

        public void run() {
            DebugUtils.find(Simantics.getSession(), GraphDebuggerView.this.debugger);
        }
    }

    class ForwardAction
    extends Action {
        public ForwardAction() {
            super(Messages.GraphDebuggerView_Forward, 1);
            this.setToolTipText(Messages.GraphDebuggerView_ForwardTT);
            this.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_FORWARD"));
            this.setDisabledImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_FORWARD_DISABLED"));
        }

        public void run() {
            GraphDebuggerView.this.forward();
        }
    }

    class HomeAction
    extends Action {
        public HomeAction() {
            super(Messages.GraphDebuggerView_Home, 1);
            this.setToolTipText(Messages.GraphDebuggerView_HomeTT);
            this.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_ETOOL_HOME_NAV"));
            this.setDisabledImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_ETOOL_HOME_NAV_DISABLED"));
        }

        public void run() {
            GraphDebuggerView.this.navigateHome();
        }
    }

    class RefreshAction
    extends Action {
        public RefreshAction() {
            super(Messages.GraphDebuggerView_Refresh, BundleUtils.getImageDescriptorFromPlugin((String)"org.simantics.ui", (String)"icons/refresh.gif"));
            this.setToolTipText(Messages.GraphDebuggerView_Refresh);
        }

        public void run() {
            GraphDebuggerView.this.refreshBrowser();
        }
    }
}

