/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.debug.browser.sections;

import java.io.PrintWriter;
import org.simantics.db.ReadGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.debug.browser.sections.ResourceBrowserSection;
import org.simantics.debug.browser.utils.Escapes;
import org.simantics.debug.browser.utils.ValueInfo;

public class ResourceInfoSection
implements ResourceBrowserSection {
    ValueInfo valueInfo;
    boolean immutable;

    public ResourceInfoSection(ValueInfo valueInfo, boolean immutable) {
        this.valueInfo = valueInfo;
        this.immutable = immutable;
    }

    @Override
    public double getPriority() {
        return 2.0;
    }

    @Override
    public void toHtml(ReadGraph graph, PrintWriter out) throws DatabaseException {
        out.println("<div id=\"resourceInfoContent\">");
        out.println("<table>");
        if (this.immutable) {
            out.println("<tr><td colspan=\"2\" id=\"immutable\">IMMUTABLE</td></tr>");
        }
        if (this.valueInfo != null) {
            if (this.valueInfo.datatype != null) {
                out.print("<tr>");
                out.print("<td class=\"top_key\">Attached value data type</td>");
                out.print("<td class=\"resourceType\">");
                out.print(Escapes.html(this.valueInfo.datatype));
                out.println("</td></tr>");
            }
            out.print("<tr><td class=\"top_key\">Attached value</td>");
            out.print("<td id=\"attachedValue\">");
            out.print(Escapes.html(this.valueInfo.value));
            out.println("</td></tr>");
        }
        out.println("</table>");
        out.println("</div>");
    }
}

