package org.simantics.db.server.internal;

import org.simantics.db.server.ProCoreException;

public class InternalException extends ProCoreException {
    private static final long serialVersionUID = -3788787186411326253L;
    InternalException(String message) {
        super(message);
    }
    InternalException(String message, Throwable cause) {
        super(message, cause);
    }
    InternalException(Throwable cause) {
        super(cause);
    }
}
class ProtocolException extends InternalException {
    private static final long serialVersionUID = 166016944501591398L;
    ProtocolException(String message) {
        super(message);
    }
    ProtocolException(String message, Throwable cause) {
        super(message, cause);
    }
    ProtocolException(Throwable cause) {
        super(cause);
    }
}
class TailReadException extends InternalException {
    private static final long serialVersionUID = -2903888693606386087L;
    TailReadException(String message) {
        super(message);
    }
    TailReadException(String message, Throwable cause) {
        super(message, cause);
    }
    TailReadException(Throwable cause) {
        super(cause);
    }
}
class TailException extends InternalException {
    private static final long serialVersionUID = 6624323178477032581L;
    TailException(String message) {
        super(message);
    }
    TailException(String message, Throwable cause) {
        super(message, cause);
    }
    TailException(Throwable cause) {
        super(cause);
    }
}
class ConnectionException extends InternalException {
    private static final long serialVersionUID = -6586144095878019338L;
    ConnectionException(String message) {
        super(message);
    }
    ConnectionException(String message, Throwable cause) {
        super(message, cause);
    }
    ConnectionException(Throwable cause) {
        super(cause);
    }
}
class NotConnectedException extends ConnectionException {
    private static final long serialVersionUID = -9022237373906063606L;
    NotConnectedException(String message) {
        super(message);
    }
    NotConnectedException(String message, Throwable cause) {
        super(message, cause);
    }
    NotConnectedException(Throwable cause) {
        super(cause);
    }
}
class ConnectionIOException extends ConnectionException {
    private static final long serialVersionUID = 774743584586684356L;
    ConnectionIOException(String message) {
        super(message);
    }
    ConnectionIOException(String message, Throwable cause) {
        super(message, cause);
    }
    ConnectionIOException(Throwable cause) {
        super(cause);
    }
}
class SendException extends ConnectionException {
    private static final long serialVersionUID = -5283126259321380935L;
    SendException(String message) {
        super(message);
    }
    SendException(String message, Throwable cause) {
        super(message, cause);
    }
    SendException(Throwable cause) {
        super(cause);
    }
}
class ReconnectException extends ConnectionException {
    private static final long serialVersionUID = -6711153874864122457L;
    ReconnectException(String message) {
        super(message);
    }
    ReconnectException(String message, Throwable cause) {
        super(message, cause);
    }
    ReconnectException(Throwable cause) {
        super(cause);
    }
}
class CompressionException extends ConnectionException {
    private static final long serialVersionUID = -2554866411795192269L;
    CompressionException(String message) {
        super(message);
    }
    CompressionException(String message, Throwable cause) {
        super(message, cause);
    }
    CompressionException(Throwable cause) {
        super(cause);
    }
}
