/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.common.request;

import org.simantics.db.AsyncReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.procedure.AsyncProcedure;
import org.simantics.layer0.Layer0;

public class TypedParent extends ResourceAsyncRead2<Resource> {

	public TypedParent(Resource resource, Resource type) {
		super(resource, type);
	}

	@Override
	public void perform(AsyncReadGraph graph, final AsyncProcedure<Resource> procedure) {

	    final Layer0 l0 = graph.getService(Layer0.class);

		graph.forIsInstanceOf(resource, resource2, new AsyncProcedure<Boolean>() {

			@Override
			public void execute(AsyncReadGraph graph, Boolean isInstance) {
				if(isInstance) {
					procedure.execute(graph, resource);
				} else {
					graph.forPossibleObject(resource, l0.PartOf, new AsyncProcedure<Resource>() {

						@Override
						public void execute(AsyncReadGraph graph, final Resource parent) {

							if(parent == null) {
								procedure.exception(graph, new DatabaseException("Typed parent was not found."));
							} else {
								graph.asyncRequest(new TypedParent(parent, resource2), procedure);
							}
							
						}

						@Override
						public void exception(AsyncReadGraph graph, Throwable throwable) {
							procedure.exception(graph, throwable);
						}
						
					});
				}
			}

			@Override
			public void exception(AsyncReadGraph graph, Throwable throwable) {
				procedure.exception(graph, throwable);
			}
		});
		
		
	}

}
