/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.common.request;

import java.util.Map;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;

final public class PossibleProperty extends BinaryRead<Resource, String, Resource> {

    public PossibleProperty(Resource resource, String name) {
        super(resource, name);
    }

    @Override
    public Resource perform(ReadGraph graph) throws DatabaseException {
    	Map<String, Resource> propertyMap = graph.syncRequest(new PropertyMapOfResource(parameter));
    	Resource property = propertyMap.get(parameter2);
    	if(property == null) return null;
    	return graph.getPossibleObject(parameter, property);
    }

}
