package org.simantics.db.common.request;

import java.util.Collection;
import java.util.Collections;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.ResourceSet;
import org.simantics.db.common.procedure.adapter.TransientCacheAsyncListener;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.service.CollectionSupport;
import org.simantics.layer0.Layer0;

public class IndexRoots extends ResourceRead<Collection<Resource>> {

	public IndexRoots(Resource r) {
		super(r);
	}

	@Override
	public Collection<Resource> perform(ReadGraph graph) throws DatabaseException {
		Layer0 L0 = Layer0.getInstance(graph);
		if (graph.isInstanceOf(resource, L0.IndexRoot))
			return Collections.singletonList(resource);
		CollectionSupport cs = graph.getService(CollectionSupport.class);
		ResourceSet types = cs.getResourceSet(graph, L0.IndexRoot);
		ResourceSetGraph rsg = graph.syncRequest(new DependentInstances3(resource), TransientCacheAsyncListener.<ResourceSetGraph>instance());
		return rsg.resolve(graph, types);
	}

}