package org.simantics.db.common.request;

import java.util.Collection;
import java.util.HashSet;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;

public class DeepObjectsWithType extends ResourceRead3<Collection<Resource>> {

	public DeepObjectsWithType(Resource subject, Resource subrelationOf, Resource instanceOf) {
        super(subject, subrelationOf, instanceOf);
    }

	@Override
	public Collection<Resource> perform(ReadGraph graph) throws DatabaseException {
		HashSet<Resource> result = new HashSet<Resource>();
		for(Resource object : graph.sync(new ObjectsWithType(resource, resource2, resource3))) {
			result.add(object);
			result.addAll(graph.sync(new DeepObjectsWithType(object, resource2, resource3)));
		}
		return result;
	}

}
