/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.common.procedure.single;

import java.util.Collection;
import java.util.HashSet;

import org.simantics.db.Disposable;
import org.simantics.db.procedure.Listener;
import org.simantics.db.procedure.SetListener;

abstract public class SingleSetListener<T> implements Listener<Collection<T>>, SetListener<T>, Disposable {
	
    private boolean disposed = false;
	
    private Collection<T> previous = null;
    
    public void add(T result) {};
    public void remove(T result) {};
    
    @Override
    public void execute(Collection<T> result) {
    	
    	if(result == null) result = new HashSet<T>();
    	
        if(previous == null) {

            for(T t : result) add(t);

        } else {

            HashSet<T> added = new HashSet<T>(result);
            added.removeAll(previous);
            HashSet<T> removed = new HashSet<T>(previous);
            removed.removeAll(result);

            for(T t : added) add(t);
            for(T t : removed) remove(t);

        }

        previous = result;
        
    }
	
    public void dispose() {
        disposed = true;
    }

    @Override
    public boolean isDisposed() {
        return disposed;
    }
    
}
