/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.common.procedure.single;

import org.simantics.db.Resource;
import org.simantics.db.procedure.AsyncListener;

public abstract class ResourceAsyncListener<T> implements AsyncListener<T> {

    final protected Resource resource;

    @Override
    public int hashCode() {
        return resource.hashCode();
    }

    @Override
    public boolean equals(Object object) {
        if (this == object)
            return true;
        else if (object == null)
            return false;
        else if (getClass() != object.getClass())
            return false;
        ResourceAsyncListener<?> r = (ResourceAsyncListener<?>) object;
        return resource.equals(r.resource);
    }

    public ResourceAsyncListener(Resource resource) {
    	if(resource == null) throw new IllegalArgumentException("Null resource.");
        this.resource = resource;
    }

}
