/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.common.primitiverequest;

import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.BinaryRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.ReadExt;
import org.simantics.db.request.RequestFlags;

final public class Value<T> extends BinaryRead<Resource, Binding, T> implements ReadExt {

    public Value(Resource resource, Binding binding) {
        super(resource, binding);
    }

    @Override
    public T perform(ReadGraph graph) throws DatabaseException {
        return graph.getValue(parameter, parameter2);
    }

	@Override
	public boolean isImmutable(ReadGraph graph) throws DatabaseException {
		return graph.isImmutable(parameter);
	}
	
	@Override
	public int getType() {
		return RequestFlags.INVALIDATE;
	}

}
