/*******************************************************************************
 *  Copyright (c) 2010 Association for Decentralized Information Management in
 *  Industry THTH ry.
 *  All rights reserved. This program and the accompanying materials
 *  are made available under the terms of the Eclipse Public License v1.0
 *  which accompanies this distribution, and is available at
 *  http://www.eclipse.org/legal/epl-v10.html
 *
 *  Contributors:
 *      VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.databoard.parser;

/**
 * This class describes the representation format of string encoding.
 *
 * @author Toni Kalajainen <toni.kalajainen@vtt.fi>
 */
public class PrintFormat {

	public static final PrintFormat SINGLE_LINE;
	public static final PrintFormat MULTI_LINE;	
	
	/** Indent sequence (Optional) */
	public String indent = null;
	/** New Line sequence (Optional) */
	public String newLine = null;
	
	public char openArray = '[';
	public char closeArray = ']';
	public String arraySeparator = ",";
	
	public char openUnion = '(';
	public char closeUnion = ')';

	public char openTuple = '(';
	public char closeTuple = ')';
	
	public char openRecord = '{';
	public char closeRecord = '}';
	
	public char openString = '\"'; 
	public char closeString = '\"';
	
	public String openLongString = "\"\"\""; 
	public String closeLongString = "\"\"\"";
	
	public String True = "true";
	public String False = "false";
	public String Null = "null";
	
	static {
		PrintFormat f = new PrintFormat();
		{
			f.indent = null;
			f.newLine = null;
			
		}
		SINGLE_LINE = f;
		
		f = new PrintFormat();
		{
			f.indent = "\t";
			f.newLine = "\n";			
		}
		MULTI_LINE = f;
	}
	
}

