/*******************************************************************************
 *  Copyright (c) 2010 Association for Decentralized Information Management in
 *  Industry THTH ry.
 *  All rights reserved. This program and the accompanying materials
 *  are made available under the terms of the Eclipse Public License v1.0
 *  which accompanies this distribution, and is available at
 *  http://www.eclipse.org/legal/epl-v10.html
 *
 *  Contributors:
 *      VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.databoard.adapter;

import org.simantics.databoard.Bindings;

/**
 * Adapter converts one java class instance to another.
 * 
 * Use {@link Bindings#getAdapter(org.simantics.databoard.binding.Binding, org.simantics.databoard.binding.Binding)}
 * to instantiate an adapter between bindings.
 */
public interface Adapter {

    /**
     * Adapt instance of one binding to format of another binding.
     * 
     * Note! adapt may recycle the argument (use it in the result).
     * This dependes on the implementation. Cloning adapter recycles only
     * immutable instances.
     * 
     * @param obj source instance
     * @return result 
     * @throws AdaptException 
     */
	public abstract Object adapt(Object obj)
	throws AdaptException;
	
    /**
     * Adapt instance of one binding to format of another binding.
     * 
     * Note! adapt may recycle the argument (use it in the result).
     * This dependes on the implementation. Cloning adapter recycles only
     * immutable instances.
     * 
     * @param obj source instance
     * @return result 
     * @throws RuntimeAdaptException 
     */
	public abstract Object adaptUnchecked(Object obj)
	throws RuntimeAdaptException;
	
	
}

