/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.browsing.ui.graph.impl.contributor.labeler;

import org.simantics.browsing.ui.BuiltinKeys;
import org.simantics.browsing.ui.CheckedState;
import org.simantics.browsing.ui.NodeContext;
import org.simantics.browsing.ui.PrimitiveQueryUpdater;
import org.simantics.browsing.ui.Tester;
import org.simantics.browsing.ui.BuiltinKeys.CheckedStateKey;
import org.simantics.browsing.ui.content.CheckedStateFactory;
import org.simantics.browsing.ui.content.Contributor;
import org.simantics.browsing.ui.graph.impl.contribution.CheckedStateContributionImpl;
import org.simantics.db.ReadGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.utils.ReflectionUtils;

abstract public class CheckedStateContributorImpl<T> implements Contributor<CheckedStateFactory> {

    abstract public CheckedState getState(ReadGraph graph, T input) throws DatabaseException;

    final private Class<?> clazz;

    @Override
    public Tester getNodeContextTester() {
        return null;
    }

    public CheckedStateContributorImpl() {
        clazz = ReflectionUtils.getSingleParameterType(getClass());
    }

    public CheckedStateContributorImpl(Class<?> clazz) {
        this.clazz = clazz;
    }

    @Override
    public CheckedStateFactory getFactory() {

        return new CheckedStateFactory() {

            @Override
            public CheckedState create(final PrimitiveQueryUpdater updater, NodeContext context, final CheckedStateKey key) {

            	CheckedStateContributionImpl contrib = new CheckedStateContributionImpl(updater, context, key) {

                    @SuppressWarnings("unchecked")
					@Override
					public CheckedState getState(ReadGraph graph, NodeContext context) throws DatabaseException {
                        T input = (T)context.getConstant(BuiltinKeys.INPUT);
						return CheckedStateContributorImpl.this.getState(graph, input);
					}

                };
                
                return contrib.getState();

            }

        };

    }

    @Override
    public Class<?> getInputClass() {
        return clazz;
    }

}
