/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.browsing.ui.graph.impl;

import java.util.Collection;
import java.util.Collections;

import org.eclipse.core.runtime.IAdaptable;
import org.simantics.browsing.ui.BuiltinKeys;
import org.simantics.browsing.ui.NodeContext;
import org.simantics.browsing.ui.NodeContext.PrimitiveQueryKey;
import org.simantics.browsing.ui.graph.impl.CommonKeys.RelatedObjectsKey;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.utils.Container;

/**
 * @author Tuukka Lehtonen
 */
public class RelatedObjectsQueryProcessor extends LazyGraphQueryProcessor<Collection<Resource>> {

    @Override
    public String toString() {
        return "RelatedObjectsProcessor";
    }

    @Override
    public Object getIdentifier() {
        return CommonKeys.RelatedObjectsKey.class;
    }

    @Override
    protected Collection<Resource> initial() {
        return Collections.emptySet();
    }

    @Override
    protected Collection<Resource> compute(ReadGraph graph, NodeContext context, PrimitiveQueryKey<Container<Collection<Resource>>> key) throws DatabaseException {
        Object input = context.getConstant(BuiltinKeys.INPUT);
        Resource subject = adaptToSingle(input, Resource.class);

        RelatedObjectsKey k = (RelatedObjectsKey) key;
        final Resource relation = k.getParameter(0);
        if (relation == null)
            return Collections.emptyList();

        return graph.getObjects(subject, relation);
    }

    @SuppressWarnings("unchecked")
    public static <T> T adaptToSingle(Object o, Class<T> clazz) {
        if (clazz.isInstance(o)) {
            return (T) o;
        } else if (o instanceof IAdaptable) {
            IAdaptable a = (IAdaptable) o;
            return (T) a.getAdapter(clazz);
        } else if (o instanceof Container<?>) {
            Object obj = ((Container<?>) o).get();
            if (obj == o)
                return null;
            return adaptToSingle(obj, clazz);
        }
        return null;
    }

}
