/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.application.db;

import java.util.Properties;

import org.simantics.db.Driver;
import org.simantics.db.Manager;
import org.simantics.db.Session;
import org.simantics.db.services.GlobalServiceInitializer;

public final class DatabaseUtils {

//    public static Session connect(String host, int port) throws Exception {
//        return connect(new ServerAddress(host, port));
//    }
//
//    public static Session connect(String host, int port, String dbid) throws Exception {
//        return connect(new ServerAddress(host, port, dbid));
//    }

    public static Session connect(String addr) throws Exception {
        // Try to load and register the Driver instance with the driver manager
        Class.forName("org.simantics.db.procore.ProCoreDriver");
        Driver driver = Manager.getDriver("procore");

        // Connect to the server at the specified host and credentials.
        // Note that we normally user authentication agent for user identification.
        Properties props = new Properties();
        props.setProperty("user", "Default User");
        props.setProperty("password", "");

        Session session = driver.getSession(addr, props);

        new GlobalServiceInitializer().initialize(session);

        return session;
    }

}
