package org.simantics.spreadsheet.synchronization;

import java.io.StringReader;
import java.util.ArrayList;

import org.simantics.databoard.adapter.AdaptException;
import org.simantics.databoard.binding.mutable.Variant;
import org.simantics.spreadsheet.ExternalRef;
import org.simantics.spreadsheet.solver.SpreadsheetBook;
import org.simantics.spreadsheet.solver.SpreadsheetCell;
import org.simantics.spreadsheet.solver.SpreadsheetFormula;
import org.simantics.spreadsheet.solver.SpreadsheetLine;
import org.simantics.spreadsheet.solver.SpreadsheetLines;
import org.simantics.spreadsheet.solver.SpreadsheetSCLConstant;
import org.simantics.spreadsheet.solver.formula.parser.SheetFormulaParser;
import org.simantics.spreadsheet.solver.formula.parser.ast.AstArrayFormulaReference;
import org.simantics.spreadsheet.solver.formula.parser.ast.AstValue;
import org.simantics.structural.synchronization.base.CommandBuilder;
import org.simantics.structural.synchronization.utils.Solver;

public class LineCommandBuilder implements CommandBuilder {

    private String name;
    LineContentBean bean;

    public LineCommandBuilder(String name, boolean update) {
        this.name = name;
    }

    @Override
    public void apply(Solver solver) {

        SpreadsheetBook book = solver.getConcreteSolver();

        String path = name.substring(0, name.lastIndexOf("/"));
        String lineName = name.substring(name.lastIndexOf("/")+1);
        int row = Integer.parseInt(lineName.substring(3));

        SpreadsheetLines node = book.ensureSubprocess(path);
        SpreadsheetLine line = node.lines.get(-row);
        if(line == null) {
            line = new SpreadsheetLine(node, row);
            node.lines.put(-row, line);
        }
        
        ArrayList<SpreadsheetCell> changes = new ArrayList<>();

        for(int i=0;i<bean.cells.length;i++) {

            SpreadsheetCell currentCell;
            if (line.cells.size() > i) {
                currentCell = line.cells.get(i);
            } else {
                currentCell = new SpreadsheetCell(line, i);
                line.cells.add(currentCell);
            }

            LineContentBeanCell cell = bean.cells[i];

            try {
                Object content = cell.getContent();
                if (content instanceof Variant) {
                    Variant cellVariant = (Variant) content;
                    if (cellVariant == LineContentBeanCell.EMPTY) {
                        currentCell.setStyle(cell.getStyleId());
                        // Empty content
                        currentCell.setContent("");
                    } else if(ExcelFormula.BINDING.type().equals(cellVariant.getBinding().type())) {
                        ExcelFormula formula = (ExcelFormula)cellVariant.getValue(ExcelFormula.BINDING);
                        SheetFormulaParser p = new SheetFormulaParser(new StringReader(formula.expression));
                        AstValue v = p.relation();
                        currentCell.setStyle(cell.getStyleId());
                        SpreadsheetFormula sformula = new SpreadsheetFormula(v, formula.expression);
                        currentCell.setContent(sformula);
                    } else if (ExcelArrayFormula.BINDING.type().equals(cellVariant.getBinding().type())) {
                        ExcelArrayFormula formula = (ExcelArrayFormula)cellVariant.getValue(ExcelArrayFormula.BINDING);
                        SheetFormulaParser p = new SheetFormulaParser(new StringReader(formula.expression));
                        AstArrayFormulaReference v = new AstArrayFormulaReference(formula.range, p.relation());
                        currentCell.setStyle(cell.getStyleId());
                        SpreadsheetFormula sformula = new SpreadsheetFormula(v, formula.expression);
                        currentCell.setContent(sformula);
                    } else if (cellVariant.getValue() instanceof ExternalRef){
                        throw new IllegalStateException();
                    } else {
                        currentCell.setStyle(cell.getStyleId());
                        // DO not update constant values during update
                        currentCell.setContent(cellVariant.getValue());
                    }
                } else if (content instanceof ExternalRef){
                    throw new IllegalStateException();
                } else if (content instanceof SpreadsheetSCLConstant){
                    currentCell.setStyle(cell.getStyleId());
                    currentCell.setContent(content);
                }
            } catch (Throwable e) {
                Object content = cell.getContent();
                if (content instanceof Variant) {
                    Variant cellVariant = (Variant) content;
                    currentCell.setStyle(cell.getStyleId());
                    currentCell.setContent(content);
                    try {
                        new Exception("failed: " + ((ExcelFormula)(cellVariant.getValue(ExcelFormula.BINDING))).expression, e).printStackTrace();
                    } catch (AdaptException e1) {
                        e1.printStackTrace();
                    }
                } else {
                    currentCell.setStyle(cell.getStyleId());
                    currentCell.setContent("LCB error happened");
                }
            }
            
            changes.add(currentCell);
            
        }
        
        book.fireChanges(changes);
        
    }

    @SuppressWarnings("unchecked")
    @Override
    public <T> T getConcrete() {
        return (T)this;
    }

}