package org.simantics.spreadsheet.solver.formula;

import org.simantics.spreadsheet.SpreadsheetMatrix;
import org.simantics.spreadsheet.Spreadsheets;
import org.simantics.spreadsheet.solver.formula.parser.ast.AstArgList;
import org.simantics.spreadsheet.solver.formula.parser.ast.AstRange;

public class CountifFormulaFunction implements CellFormulaFunction<Integer> {

    @Override
    public Integer evaluate(CellValueVisitor visitor, AstArgList args) {
        if (args.values.size() != 2) throw new IllegalStateException();

        AstRange range = (AstRange) args.values.get(0);
        SpreadsheetMatrix matrix = (SpreadsheetMatrix) range.accept(visitor);
        Object crit = null;
        try {
            crit = args.values.get(1).accept(visitor);
        } catch (IllegalStateException e){
            return 0;
        }

        String criteria = Spreadsheets.asString(crit);
        int result = 0;
        for (Object value : matrix.values) {
            if (Spreadsheets.matchCriteria(value, criteria))
                result++;
        }
        return Integer.valueOf(result);
    }
}
