package org.simantics.spreadsheet;

import java.util.Collections;
import java.util.Map;

import org.simantics.spreadsheet.solver.SheetNode;
import org.simantics.spreadsheet.solver.SpreadsheetCell;

@SuppressWarnings("rawtypes")
public class SpreadsheetCellStyle implements SheetNode {

    private static final long serialVersionUID = -219628109106298874L;
    
    public final SpreadsheetCell cell;

    public SpreadsheetCellStyle(SpreadsheetCell spreadsheetCell) {
        this.cell = spreadsheetCell;
    }

    @Override
    public String getName() {
        return "style";
    }

    @Override
    public Map getChildren() {
        return Collections.emptyMap();
    }

    @Override
    public Map getProperties() {
        return Collections.emptyMap();
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + ((cell == null) ? 0 : cell.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        SpreadsheetCellStyle other = (SpreadsheetCellStyle) obj;
        if (cell == null) {
            if (other.cell != null)
                return false;
        } else if (!cell.equals(other.cell))
            return false;
        return true;
    }

}
