/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.objmap.structural.annotations.factories;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.ResourceNotFoundException;
import org.simantics.db.exception.ServiceException;
import org.simantics.db.exception.ValidationException;
import org.simantics.objmap.bidirectional.IBidirectionalMappingRule;
import org.simantics.objmap.graph.annotations.RelatedValue;
import org.simantics.objmap.graph.rules.ValueRule;
import org.simantics.objmap.graph.rules.adapters.IdentityAdapter;
import org.simantics.objmap.graph.rules.adapters.ValueAdapter;
import org.simantics.objmap.graph.rules.factory.IFieldRuleFactory;
import org.simantics.objmap.graph.rules.range.AdaptedRangeAccessor;
import org.simantics.objmap.graph.rules.range.FieldAccessor;
import org.simantics.objmap.graph.rules.range.IRangeAccessor;
import org.simantics.objmap.structural.StructuralResource;
import org.simantics.objmap.structural.annotations.factories.DataTypeUtils;
import org.simantics.objmap.structural.rules.domain.RelatedValueAccessor;

public class RelatedValueRuleFactory<Range>
implements IFieldRuleFactory<StructuralResource, Range> {
    @Override
    public IBidirectionalMappingRule<StructuralResource, Range> create(ReadGraph g, Annotation _annotation, Field field) throws ResourceNotFoundException, ValidationException, ServiceException {
        Resource valueType;
        RelatedValue annotation = (RelatedValue)_annotation;
        Class<? extends ValueAdapter> adapterClass = annotation.adapter();
        IRangeAccessor rangeAccessor = new FieldAccessor(field);
        if (adapterClass == IdentityAdapter.class) {
            valueType = DataTypeUtils.dataTypeOfClass(g, field.getType());
        } else {
            try {
                ValueAdapter adapter = adapterClass.newInstance();
                rangeAccessor = new AdaptedRangeAccessor(rangeAccessor, adapter);
                valueType = adapter.rangeTypeToDomainType(g, field.getType());
            }
            catch (InstantiationException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
        return new ValueRule(new RelatedValueAccessor(g.getResource(annotation.value()), valueType, false, true, false), rangeAccessor);
    }
}

