/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.objmap.graph.rules.domain;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.utils.ListUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.ManyObjectsForFunctionalRelationException;
import org.simantics.db.exception.NoSingleResultException;
import org.simantics.db.exception.ServiceException;
import org.simantics.layer0.Layer0;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MappingUtils {
    static final Logger LOGGER = LoggerFactory.getLogger(MappingUtils.class);

    public static boolean synchronizeStatements(WriteGraph g, Resource subject, Resource predicate, Resource[] objects, boolean deleteExtraObjects) throws DatabaseException {
        Collection currentObjects0 = g.getObjects(subject, predicate);
        Object[] currentObjects = currentObjects0.toArray(new Resource[currentObjects0.size()]);
        Arrays.sort(objects);
        Arrays.sort(currentObjects);
        boolean modified = false;
        int i = 0;
        int j = 0;
        if (currentObjects.length > 0 && objects.length > 0) {
            while (true) {
                int cmp;
                if ((cmp = currentObjects[i].compareTo((Object)objects[j])) < 0) {
                    LOGGER.trace("            remove statement");
                    if (deleteExtraObjects) {
                        g.deny((Resource)currentObjects[i]);
                    } else {
                        g.denyStatement(subject, predicate, (Resource)currentObjects[i]);
                    }
                    modified = true;
                    if (++i < currentObjects.length) continue;
                    break;
                }
                if (cmp > 0) {
                    LOGGER.trace("            add statement");
                    g.claim(subject, predicate, objects[j]);
                    modified = true;
                    if (++j < objects.length) continue;
                    break;
                }
                if (++i >= currentObjects.length || ++j >= objects.length) break;
            }
        }
        while (i < currentObjects.length) {
            if (deleteExtraObjects) {
                g.deny((Resource)currentObjects[i]);
            } else {
                g.denyStatement(subject, predicate, (Resource)currentObjects[i]);
            }
            modified = true;
            ++i;
        }
        while (j < objects.length) {
            g.claim(subject, predicate, objects[j]);
            modified = true;
            ++j;
        }
        return modified;
    }

    public static boolean synchronizeList(WriteGraph g, Resource element, Resource relation, Resource listType, List<Resource> value, boolean deleteExtraObjects) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)g);
        boolean modified = false;
        Resource currentList = g.getPossibleObject(element, relation);
        if (currentList == null) {
            currentList = ListUtils.create((WriteGraph)g, (Resource)listType, (Resource[])new Resource[0]);
            g.claim(element, relation, currentList);
            modified = true;
        }
        List currentNodes = ListUtils.getListNodes((ReadGraph)g, (Resource)currentList);
        int i = 0;
        int j = 0;
        while (i < currentNodes.size()) {
            Resource node = (Resource)currentNodes.get(i);
            Resource v = g.getSingleObject(node, L0.List_Element);
            if (j < value.size() && v.equals(value.get(j))) {
                ++i;
                ++j;
                continue;
            }
            if (value.indexOf(v) > j) {
                MappingUtils.insertElementBefore(g, L0, node, value.get(j));
                modified = true;
                ++j;
                continue;
            }
            if (deleteExtraObjects) {
                g.deny(v);
            }
            MappingUtils.removeNode(g, L0, node);
            modified = true;
            ++i;
        }
        while (j < value.size()) {
            MappingUtils.insertElementBefore(g, L0, currentList, value.get(j));
            modified = true;
            ++j;
        }
        return modified;
    }

    private static Resource insertElementBefore(WriteGraph g, Layer0 L0, Resource node, Resource val) throws NoSingleResultException, ManyObjectsForFunctionalRelationException, ServiceException {
        Resource prev = g.getSingleObject(node, L0.List_Previous);
        g.deny(prev, L0.List_Next, L0.List_Previous, node);
        Resource newNode = g.newResource();
        g.claim(newNode, L0.InstanceOf, L0.List_Entry);
        g.claim(prev, L0.List_Next, L0.List_Previous, newNode);
        g.claim(newNode, L0.List_Next, L0.List_Previous, node);
        g.claim(newNode, L0.List_Element, val);
        return newNode;
    }

    private static void removeNode(WriteGraph g, Layer0 L0, Resource node) throws NoSingleResultException, ManyObjectsForFunctionalRelationException, ServiceException {
        Resource prev = g.getSingleObject(node, L0.List_Previous);
        Resource next = g.getSingleObject(node, L0.List_Next);
        g.claim(prev, L0.List_Next, L0.List_Previous, next);
        g.deny(node);
    }
}

