/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.image.ui.modelBrowser.handlers;

import java.io.File;
import java.util.Collection;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;
import org.simantics.Simantics;
import org.simantics.db.Resource;
import org.simantics.image.ui.CreateImages;
import org.simantics.image.ui.ImportImagesActionFactory;
import org.simantics.image.ui.modelBrowser.ImagesNode;
import org.simantics.utils.ui.AdaptionUtils;

/**
 * @author J-P Laine
 */
public class ImportImageHandler extends AbstractHandler {

    @Override
    public Object execute(ExecutionEvent event) throws ExecutionException {
        final Shell shell = HandlerUtil.getActiveShell(event);

        ISelection selection = HandlerUtil.getCurrentSelection(event);
        ImagesNode images = AdaptionUtils.adaptToSingle(selection, ImagesNode.class);
        if (images == null)
            return null;
        final Resource container = images.data;

        Collection<File> files = ImportImagesActionFactory.requestImportedImages(shell);
        if (files.isEmpty())
            return null;

        Simantics.getSession().asyncRequest( new CreateImages(container, files) );

        return null;
    }

}
