package org.simantics.graph.compiler.internal.procedures;

import org.simantics.graph.query.IGraph;
import org.simantics.graph.query.Paths;
import org.simantics.graph.query.Res;
import org.simantics.graph.store.GraphStore;
import org.simantics.graph.store.StatementStore;

import gnu.trove.list.array.TIntArrayList;
import gnu.trove.map.hash.TIntIntHashMap;

public class CreateInverseRelations implements Runnable {
	IGraph graph;
	GraphStore store;
	
	public CreateInverseRelations(IGraph graph, GraphStore store) {
		this.graph = graph;
		this.store = store;
	}
	
	@Override
	public void run() {
	    Paths paths = graph.getPaths();
		int subrelationOf = store.identities.pathToId(paths.SubrelationOf);
		if(subrelationOf < 0)
			return;
		
		int inverseOf = store.identities.createPathToId(paths.InverseOf);
		
		int resourceCount = store.identities.getResourceCount();
		TIntIntHashMap inverseMap = new TIntIntHashMap();
		StatementStore statements = store.statements;
		for(int id = 0;id<resourceCount;++id) {
			TIntArrayList objects = statements.getObjects(id, inverseOf);
			if(!objects.isEmpty()) {
				inverseMap.put(id, objects.get(0));
				for(int i=0;i<objects.size();++i)
					inverseMap.put(objects.get(i), id);
			}
		}
		boolean mod = true;
		while(mod) {
			mod = false;
			for(int id = 0;id<resourceCount;++id)
				if(store.identities.isNewResource(id) || !store.identities.hasIdentity(id)) {
					TIntArrayList superrelations =
						store.statements.getObjects(id, subrelationOf);
					TIntArrayList invSuperrelations = new TIntArrayList(superrelations.size());
					for(int superrelation : superrelations.toArray())
						for(Res invSuperrelation : graph.rawGetObjects(store.idToRes(superrelation), 
						        paths.InverseOf))						
							invSuperrelations.add(store.createResToId(invSuperrelation));
					
					// Create inverse
					if(!invSuperrelations.isEmpty()) {
						//TIntArrayList inverses = store.statements.getObjects(id, inverseOf);
						int inverse;
						if(!inverseMap.containsKey(id)) {						
							if(store.identities.hasIdentity(id)) {
								inverse = store.identities.getChild(id, "Inverse");
								store.identities.markNew(inverse);
							}
							else
								inverse = store.identities.newResource();
							inverseMap.put(id, inverse);
							inverseMap.put(inverse, id);
							store.statements.add(id, inverseOf, inverse);
							mod = true;
						}
						else {
							inverse = inverseMap.get(id);
							for(int curSuperrelation : store.statements.getObjects(inverse, subrelationOf).toArray()) {
								int i = invSuperrelations.indexOf(curSuperrelation);
								if(i >= 0) {
									invSuperrelations.set(i, 
											invSuperrelations.get(invSuperrelations.size()-1));
									invSuperrelations.removeAt(invSuperrelations.size()-1);
								}
							}
						}					 
						
						for(int invSuperrelation : invSuperrelations.toArray())
							store.statements.add(inverse, subrelationOf, invSuperrelation);
					}
				}
		}
	}
}
